DELIMITER $$
DROP PROCEDURE IF EXISTS V20221129173017__Update_StudentTransferEventRecipient $$
CREATE PROCEDURE V20221129173017__Update_StudentTransferEventRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');
update sql_dtprovider set sqlQuery = "SELECT 
    servicereq6_.id AS ID,
(CASE
        WHEN
            (select pgc1.defaultAssigneeUserId from
            student_transfer_request_details this_ 
				left outer join
			service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId where
        servicereq6_.id IN (namedParams) group by srs.id) IS NOT NULL
        THEN
            (SELECT 
                    CONCAT(usr.firstName, ' ',
                                IFNULL(usr.lastName, ' ')) AS name
                FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId
    left outer join staffs stf on stf.userId=pgc1.defaultAssigneeUserId
    left outer join users usr on usr.id=stf.userId
    left outer join persons per on stf.personId=per.id
    where
        servicereq6_.id IN (namedParams) group by srs.id) 
        ELSE (select CONCAT(useradmin.firstName,
                IFNULL(useradmin.middleName, ' '),
                IFNULL(useradmin.lastName, ' ')) from users as useradmin  where code='SYSADMIN')
    END) AS FIRST_NAME,
    (CASE
        WHEN
            (select pgc1.defaultAssigneeUserId from
            student_transfer_request_details this_ 
				left outer join
			service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId where
        servicereq6_.id IN (namedParams) group by srs.id) IS NOT NULL
        THEN
            (SELECT 
                    per.emailId AS mailId
                FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId
    left outer join staffs stf on stf.userId=pgc1.defaultAssigneeUserId
    left outer join users usr on usr.id=stf.userId
    left outer join persons per on stf.personId=per.id
    where
        servicereq6_.id IN (namedParams) group by srs.id)
        ELSE (select useradmin.emailId from users as useradmin  where code='SYSADMIN')
    END) AS EMAIL_ID,
   (CASE
        WHEN
            (select pgc1.defaultAssigneeUserId from
            student_transfer_request_details this_ 
				left outer join
			service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId where
        servicereq6_.id IN (namedParams) group by srs.id) IS NOT NULL
        THEN
            (SELECT 
                    per.mobileNumber AS mobileNumber
                FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
   left outer  join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
   left outer  join program_group pg on pg.id=prg.programGroupId
   left outer  join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
   left outer  join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId
   left outer  join staffs stf on stf.userId=pgc1.defaultAssigneeUserId
   left outer  join users usr on usr.id=stf.userId
   left outer  join persons per on stf.personId=per.id
    where
        servicereq6_.id IN (namedParams) group by srs.id)
        ELSE (select per.mobileNumber from users as useradmin   LEFT JOIN staffs stt on stt.userId= useradmin.id
					 LEFT JOIN persons per on per.id= useradmin.id where code='SYSADMIN')
    END) AS MOBILE_NO,

(CASE
        WHEN
            (select pgc1.defaultAssigneeUserId from
            student_transfer_request_details this_ 
				left outer join
			service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
   left outer  join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
   left outer  join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
  left outer   join program_group pg on pg.id=prg.programGroupId
   left outer  join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
   left outer  join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId where
        servicereq6_.id IN (namedParams) group by srs.id) IS NOT NULL
	THEN
(SELECT usr.printName AS DEFAULT_APPROVER
                FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
  left outer   join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
  left outer   join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
  left outer   join program_group pg on pg.id=prg.programGroupId
  left outer   join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
   left outer  join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId
  left outer   join staffs stf on stf.userId=pgc1.defaultAssigneeUserId
  left outer   join users usr on usr.id=stf.userId
  left outer   join persons per on stf.personId=per.id
    where
        servicereq6_.id IN (namedParams) group by srs.id) 
	ELSE (select printName from users as useradmin  where code='SYSADMIN')
    END) AS DEFAULT_APPROVER,



    (select IFNULL(itemValue, ' ') as  itemValue from registration_type as rt WHERE rt.id = toprogram7_.registrationTypeId AND  toprogram7_.registrationTypeId IS NOT NULL AND rt.id IS NOT NULL) AS PROGRAM_STATUS,
    tobatch8_.batchName AS BATCH_NAME,
     toprogram7_.programName AS PROGRAM_NAME,
       CONCAT(fromal2_.academyName,
            '-',
            fromal2_.locationName) AS FROM_LOCATION,
    CONCAT(CONCAT(person5_.firstName, ' '),
            IFNULL(CONCAT(person5_.middleName, ' '), ''),
            IFNULL(CONCAT(person5_.lastName, ' '), '')) AS STUDENT_NAME,
    CONCAT(toal3_.academyName,
            '-',
            toal3_.locationName) AS TO_LOCATION,
            student4_1_.code AS STUDENT_ID
FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join service_request_settings srs on srs.academyLocationId=this_.toALId and srs.requestType='Student Transfer'  
    left outer join service_request_program_group_config pgc on pgc.serviceRequestSettingId=srs.id
	left outer join programs prg on prg.id=this_.toProgramId
    left outer join program_group pg on pg.id=prg.programGroupId
    left outer join program_group_details pgd on pgd.programGroupId=pg.id and prg.academyLocationId=pgd.academyLocationId
    left outer join service_request_program_group_config pgc1 on pgc1.programGroupDetailsId=pgd.id and srs.id=pgc1.serviceRequestSettingId
    left outer join staffs stf on stf.userId=pgc1.defaultAssigneeUserId
    left outer join users usr on usr.id=stf.userId
    left outer join persons per on stf.personId=per.id
    left outer join
        programs program14_ 
            on servicereq6_.currentProgram=program14_.id 
    left outer join
        request_status requeststa15_ 
            on servicereq6_.requestStatusId=requeststa15_.id 
    left outer join
        academy_location fromal2_ 
            on this_.fromALId=fromal2_.id 
    left outer join
        currency currency19_ 
            on fromal2_.currencyId=currency19_.id 
    left outer join
        admission fromadmiss1_ 
            on this_.fromAdmissionId=fromadmiss1_.id 
    left outer join
        students student4_ 
            on fromadmiss1_.studentId=student4_.userId 
    left outer join
        users student4_1_ 
            on student4_.userId=student4_1_.id 
    left outer join
        persons person5_ 
            on student4_.personId=person5_.id 
    left outer join
        drop_down dropdown23_ 
            on this_.reasonForLeaving=dropdown23_.id 
    left outer join
        academy_location toal3_ 
            on this_.toALId=toal3_.id 
    left outer join
        batches tobatch8_ 
            on this_.toBatchId=tobatch8_.id 
    left outer join
        batches_cd batchcusto26_ 
            on tobatch8_.id=batchcusto26_.batchId 
    left outer join
        programs toprogram7_ 
            on this_.toProgramId=toprogram7_.id 
    left outer join
        program_cd programcus28_ 
            on toprogram7_.id=programcus28_.programId 
    where
        servicereq6_.id IN (namedParams) group by srs.id" where dataProviderId=@dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221129173017__Update_StudentTransferEventRecipient () $$
DROP PROCEDURE IF EXISTS V20221129173017__Update_StudentTransferEventRecipient $$
DELIMITER ;