DELIMITER $$
DROP PROCEDURE IF EXISTS V20221130145241__Create_submitApplicationOrPaidForBuzzEvent $$
CREATE PROCEDURE V20221130145241__Create_submitApplicationOrPaidForBuzzEvent()
BEGIN

IF NOT EXISTS ((select id from `system_msg_event` where code='APPLICATION_SUBMIT_BUZZ')) THEN 
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SUBMIT_APPLICATION_FORM');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SUBMIT_APPLICATION_FORM');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_SUBMIT_BUZZ', 'Application Submit Buzz', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Submit Buzz','Application Submit Buzz');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);



SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_SUBMIT_BUZZ_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_SUBMIT_BUZZ_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_SUBMIT_BUZZ_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_SUBMIT_BUZZ_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_SUBMIT_BUZZ_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_SUBMIT_BUZZ_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_SUBMIT_BUZZ_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID,T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID FROM 
application_program T1 INNER JOIN `prog_batch_seat_config` T3 ON T3.id = T1.`progBatchSeatConfigId` WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_SUBMIT_BUZZ_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select T4.id AS ID,
T1.`code` AS APPLICATION_ID,
 	T2.`firstName` AS APPLICANT_FIRST_NAME,
	T2.`firstName` AS FIRST_NAME,
 	T2.`lastName` AS APPLICANT_LAST_NAME,
	T21.`salutationName` AS PARENT_SALUTATION,
    T20.`firstName` AS PARENT_FIRST_NAME,
     T20.`lastName` AS PARENT_LAST_NAME,
 	T2.`emailId` AS EMAIL_ID,
 	T2.`mobileNumber` AS MOBILE_NO,
    T2.`shortName` AS APPLICANT_OTHER_NAME,
     T5.displayName AS ACADEMY_NAME_LOCATION,
     T5.academyName AS ACADEMY_NAME,
     T5.locationName AS LOCATION_NAME,
     CONCAT(T7.phoneCountryCode,'-',T7.phoneAreaCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NUMBER,
     T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL,
     T11.programName AS PROGRAM_NAME,
     T13.batchName AS INTAKE,
     T18.seatName AS SEAT_TYPE,
         (CASE
         WHEN
             T5.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (CASE
         WHEN
             T5.footerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.footerUrl)
         ELSE NULL
     END) AS FOOTER_URL,
     (CASE
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
     END) AS LOGO_URL,
     T7.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL
     from application_program T4
 		left outer join
     application T1 on T4.applicationId = T1.id
 		left outer join
     applicant_person T2 on T1.applicantPersonId=T2.id
 		LEFT OUTER JOIN
        applicant_person_relationships T19 on (T19.applicantPersonId=T2.id and T19.relationship in ('FATHER','MOTHER') and T19.whetherDeleted=false)
        LEFT OUTER JOIN
        applicant_person as T20 on T20.id=T19.relatedApplicantPersonId
          LEFT OUTER JOIN
          salutations as T21 on T21.id=T20.salutationId
       LEFT OUTER JOIN
     academy_location T5 ON T5.id = T4.academyLocationId
 		LEFT OUTER JOIN
     academy_location_addresses T6 ON T6.academyLocationId = T5.id
 		LEFT OUTER JOIN
     address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
 		LEFT OUTER JOIN
 	city T8 ON T8.id = T7.cityId
 		LEFT OUTER JOIN
 	country T9 ON T9.id = T8.countryId
 		LEFT OUTER JOIN
 	country_region T10 ON T10.id = T8.countryRegionId
 		LEFT OUTER JOIN
 	programs T11 ON T11.id = T4.programId		
 		LEFT JOIN       
     prog_batch_seat_config T17 on T17.id = T4.progBatchSeatConfigId
     LEFT JOIN
 	batches T13 ON T13.programId=T11.id and T13.id = T17.programBatchId
      LEFT JOIN
     seat_types T18 ON T18.id = T17.seatTypeId
      LEFT JOIN
 	users T14 ON T14.id=T1.applicationOwner
 		LEFT JOIN
     staffs T15 ON T15.userId = T14.id
         LEFT JOIN
     persons T16 ON T16.id = T15.personId
 		LEFT JOIN
     multi_language ml ON ml.id = T2.correspondence_language
 		LEFT OUTER JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations)
     where T4.id in(namedParams) order by T19.relationship asc limit 1;
     ",'{
     "id": 1,
     "searchResultViewColumns": [
 		{
             "id": 1,
             "value": "code",
             "resultKey": "APPLICATION_ID",
             "displayCode": "",
             "displayOrder": 0
         },
         {
             "id": 2,
             "value": "firstName",
             "resultKey": "APPLICANT_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 1
         },
         {
             "id": 3,
             "value": "lastName",
             "resultKey": "APPLICANT_LAST_NAME",
             "displayCode": "",
             "displayOrder": 2
         },
            {
             "id": 4,
             "value": "salutationName",
             "resultKey": "PARENT_SALUTATION",
             "displayCode": "",
             "displayOrder": 3
         },
            {
             "id": 5,
             "value": "firstName",
             "resultKey": "PARENT_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 4
         },
            {
             "id": 6,
             "value": "lastName",
             "resultKey": "PARENT_LAST_NAME",
             "displayCode": "",
             "displayOrder": 5
         },
 		{
             "id": 7,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 6
         },
 		{
             "id": 8,
             "value": "mobileNumber",
             "resultKey": "MOBILE_NO",
             "displayCode": "",
             "displayOrder": 7
         },
         	{
             "id": 9,
             "value": "shortName",
             "resultKey": "APPLICANT_OTHER_NAME",
             "displayCode": "",
             "displayOrder": 8
         },
          {
             "id": 10,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 9
         },
         {
             "id": 11,
             "value": "displayName",
             "resultKey": "ACADEMY_NAME_LOCATION",
             "displayCode": "",
             "displayOrder": 10
         },
         {
             "id": 12,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 11
         
         },
         {
             "id": 13,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 12
         },
         {
             "id": 14,
             "value": "batchName",
             "resultKey": "INTAKE",
             "displayCode": "",
             "displayOrder": 13
         },
 		{
             "id": 15,
             "value": "seatName",
             "resultKey": "SEAT_TYPE",
             "displayCode": "",
             "displayOrder": 14
         },
         {
             "id": 16,
             "value": "logoUrl",
             "resultKey": "LOGO_URL",
             "displayCode": "",
             "displayOrder": 15
         },
 		 {
             "id": 17,
             "value": "headerUrl",
             "resultKey": "HEADER_URL",
             "displayCode": "",
             "displayOrder": 16
         },
 		 {
             "id": 18,
             "value": "footerUrl",
             "resultKey": "FOOTER_URL",
             "displayCode": "",
             "displayOrder": 17
         },
 		 {
             "id": 19,
             "value": "ACADEMY_LOCATION_PHONE_NO",
             "resultKey": "ACADEMY_LOCATION_PHONE_NUMBER",
             "displayCode": "",
             "displayOrder": 18
         },
 		 {
             "id": 20,
             "value": "primaryeEmailId",
             "resultKey": "ACADEMY_LOCATION_EMAIL",
             "displayCode": "",
             "displayOrder": 19
         },
         {
             "id": 21,
             "value": "websiteURL",
             "resultKey": "ACADEMY_LOCATION_WEBSITE_URL",
             "displayCode": "",
             "displayOrder": 20
         }
     ]
 }');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_SUBMIT_BUZZ');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SUBMIT_APPLICATION_FORM');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_SUBMIT_BUZZ_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'APPLICATION_SUBMIT_BUZZ',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Submit Buzz',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',b'1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application submitted','<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">Dear #[&quot;APPLICANT_FIRST_NAME&quot;] #[&quot;APPLICANT_LAST_NAME&quot;] </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">Congratulations, we are pleased to inform you that your application to study with us is received! </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">Please find your attached Application Confirmation letter. </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">We look forward to engaging with you further.</span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">Kind regards, </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">#[&quot;ACADEMY_NAME_LOCATION&quot;] </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">#[&quot;ACADEMY_LOCATION_EMAIL&quot;] </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">#[&quot;ACADEMY_LOCATION_PHONE NUMBER&quot;] </span></p>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">#[ACADEMY_LOCATION_WEBSITE_URL&quot;}</span></p>
</body>
</html>
');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(255, 255, 255);">Dear #[&quot;APPLICANT_FIRST_NAME&quot;] #[&quot;APPLICANT_LAST_NAME&quot;] Congratulations, we are pleased to inform you that your application to study with us is received! Please find your attached Application Confirmation letter.We look forward to engaging with you further.Kind regards,#[&quot;ACADEMY_NAME_LOCATION&quot;] #[&quot;ACADEMY_LOCATION_EMAIL&quot;] #[&quot;ACADEMY_LOCATION_PHONE NUMBER&quot;] #[ACADEMY_LOCATION_WEBSITE_URL&quot;}</span></p>
</body>
</html>');


-- Create new document type for this event to map dynamic document

SET @msgtemplateconfigId=(select id from msg_template_config where code='APPLICATION_SUBMIT_BUZZ');
SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@dydtdocumenttypeId+1,'Application Submission Letter', 'PROGRAM_BATCH_SEAT_TYPE_LEVEL', '0', 'APPLICATION_SUBMIT_BUZZ', '0', '1');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='DLS_PROGRAM_BATCH_SEAT_CONFIG_ID');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{\"MSG_PARAM\":\"CONTEXT_RECORD_ID\",\"DOC_GEN_PARAM\":\"PRM_APPLICATION_PROGRAM_ID\"}]');

-- Start : Mapping of Dynamic Document to MsgTemplate

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);

-- End : Mapping of Dynamic Document to Msgtemplate

SET @dataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);

INSERT INTO `dydt_data_provider` (`id`,`providerName`,`priority`) values (@dataproviderId+1,'APPLICATION_SUBMIT_PROVIDER',1);

SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider` where `providerName`='APPLICATION_SUBMIT_PROVIDER');
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId, @dydtdocumenttypeId+1);

SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dydtdatalinitemId+1,@dydtdataproviderId, 'APPLICATION_SUBMIT_PROVIDER_INFO', '1',null, '1', '1', 
"select T4.id AS ID,
T1.`code` AS APPLICATION_ID,
 	T2.`firstName` AS APPLICANT_FIRST_NAME,
 	T2.`lastName` AS APPLICANT_LAST_NAME,
	T21.`salutationName` AS PARENT_SALUTATION,
    T20.`firstName` AS PARENT_FIRST_NAME,
     T20.`lastName` AS PARENT_LAST_NAME,
 	T2.`emailId` AS EMAIL_ID,
 	T2.`mobileNumber` AS MOBILE_NO,
    T2.`shortName` AS APPLICANT_OTHER_NAME,
     T5.displayName AS ACADEMY_NAME_LOCATION,
     T5.academyName AS ACADEMY_NAME,
     T5.locationName AS LOCATION_NAME,
     CONCAT(T7.phoneCountryCode,'-',T7.phoneAreaCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NUMBER,
     T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL,
     T11.programName AS PROGRAM_NAME,
     T13.batchName AS INTAKE,
     T18.seatName AS SEAT_TYPE,
         (CASE
         WHEN
             T5.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (CASE
         WHEN
             T5.footerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.footerUrl)
         ELSE NULL
     END) AS FOOTER_URL,
     (CASE
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
     END) AS LOGO_URL,
     T7.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL
     from application_program T4
 		left outer join
     application T1 on T4.applicationId = T1.id
 		left outer join
     applicant_person T2 on T1.applicantPersonId=T2.id
 		LEFT OUTER JOIN
        applicant_person_relationships T19 on (T19.applicantPersonId=T2.id and T19.relationship in ('FATHER','MOTHER') and T19.whetherDeleted=false)
        LEFT OUTER JOIN
        applicant_person as T20 on T20.id=T19.relatedApplicantPersonId
          LEFT OUTER JOIN
          salutations as T21 on T21.id=T20.salutationId
       LEFT OUTER JOIN
     academy_location T5 ON T5.id = T4.academyLocationId
 		LEFT OUTER JOIN
     academy_location_addresses T6 ON T6.academyLocationId = T5.id
 		LEFT OUTER JOIN
     address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
 		LEFT OUTER JOIN
 	city T8 ON T8.id = T7.cityId
 		LEFT OUTER JOIN
 	country T9 ON T9.id = T8.countryId
 		LEFT OUTER JOIN
 	country_region T10 ON T10.id = T8.countryRegionId
 		LEFT OUTER JOIN
 	programs T11 ON T11.id = T4.programId		
 		LEFT JOIN       
     prog_batch_seat_config T17 on T17.id = T4.progBatchSeatConfigId
     LEFT JOIN
 	batches T13 ON T13.programId=T11.id and T13.id = T17.programBatchId
      LEFT JOIN
     seat_types T18 ON T18.id = T17.seatTypeId
      LEFT JOIN
 	users T14 ON T14.id=T1.applicationOwner
 		LEFT JOIN
     staffs T15 ON T15.userId = T14.id
         LEFT JOIN
     persons T16 ON T16.id = T15.personId
 		LEFT JOIN
     multi_language ml ON ml.id = T2.correspondence_language
 		LEFT OUTER JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations)", 'PRM_APPLICATION_PROGRAM_ID','APPLICATION_ID,APPLICANT_FIRST_NAME,APPLICANT_LAST_NAME,PARENT_SALUTATION,PARENT_FIRST_NAME,PARENT_LAST_NAME,EMAIL_ID,MOBILE_NO,APPLICANT_OTHER_NAME,ACADEMY_NAME_LOCATION,ACADEMY_NAME
             ,LOCATION_NAME,ACADEMY_LOCATION_PHONE_NUMBER,ACADEMY_LOCATION_EMAIL,PROGRAM_NAME,INTAKE,SEAT_TYPE,HEADER_URL,FOOTER_URL,LOGO_URL,ACADEMY_LOCATION_WEBSITE_URL', 'where T4.id=PRM_APPLICATION_PROGRAM_ID order by T19.relationship asc limit 1;', '0');

   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICATION_ID', 'Application ID',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_FIRST_NAME', 'Applicant First Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_LAST_NAME', 'Applicant Last Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PARENT_SALUTATION', 'Parent Salutation',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PARENT_FIRST_NAME', 'Parent First Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PARENT_LAST_NAME', 'Parent Last Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('EMAIL_ID', 'Email Id',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MOBILE_NO', 'Mobile No',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_OTHER_NAME', 'Applicant Other Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_NAME_LOCATION', 'Academy Location Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_NAME', 'Academy Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LOCATION_NAME', 'Location Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_LOCATION_PHONE_NUMBER', 'Academy Location Phone Number',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_LOCATION_EMAIL', 'Academy Location Email',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_NAME', 'Program Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('INTAKE', 'Intake',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('SEAT_TYPE', 'Seat Type',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('HEADER_URL', 'Header URL',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('FOOTER_URL', 'Footer URL',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LOGO_URL', 'Logo URL',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_LOCATION_WEBSITE_URL', 'ACademy Location Website URL',@dydtdatalinitemId);
END IF; 


END $$
CALL V20221130145241__Create_submitApplicationOrPaidForBuzzEvent () $$ 
DROP PROCEDURE IF EXISTS V20221130145241__Create_submitApplicationOrPaidForBuzzEvent $$ 
DELIMITER ;