DELIMITER $$
DROP PROCEDURE IF EXISTS V20230124124129__Insert_RESIDENCE_ROOM_ALLOTMENT $$
CREATE PROCEDURE V20230124124129__Insert_RESIDENCE_ROOM_ALLOTMENT()
BEGIN

IF NOT EXISTS ((select * from system_msg_event where code='STUDENT_HOSTEL_ROOM_ALLOTMENT')) THEN 

--  Messaging for Hostel Room Allotment Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'RESIDENCE_ROOM_ALLOTMENT');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='RESIDENCE_ROOM_ALLOTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'STUDENT_HOSTEL_ROOM_ALLOTMENT', 'Hostel Room Allotment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Hostel Room Allotment');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_HOSTEL_ROOM_ALLOTMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_ROOM_ALLOTMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_ROOM_ALLOTMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select id as USER_ID from hostel_room_allotment  where id in(namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id as ID,
    T3.code as STUDENT_NUMBER,
    T3.firstName as STUDENT_FIRST_NAME,
	T3.firstName as FIRST_NAME,
	T3.printName as PRINT_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T3.printName AS STUDENT_PRINT_NAME,
    T4.emailId as EMAIL_ID,
    T4.mobileCountryCode as MOBILE_CODE,
    T4.mobileNumber as MOBILE_NO,
    T10.resourceName as BUILDING_NAME,
    T6.floorNumber as FLOOR_NAME,
    T5.roomNumber as ROOM_NUMBER,
    T7.bedNumber as BED_NUMBER,
    T11.resourceName as SU_HOSTEL_NAME,
    T11.code as HOSTEL_CODE,
    T12.roomType as ROOM_TYPE,
    T1.allotmentDate as ALLOTMENT_DATE,
    T1.expectedCheckOutDate as AVAILABLE_FROM,
    T13.printName as MANAGER_NAME,
    T14.printName as ALLOTMENT_BY
FROM
    hostel_room_allotment T1
    left join students T2 on T2.userId =T1.studentId
    left join users T3 on T3.id =T2.userId
    left join persons T4 on T4.id =T2.personId
    left join hostel_room T5 on T5.id =T1.roomId
    left join hostel_floor T6 on T6.id =T5.floorId
    left join hostel_bed T7 on T7.id =T5.id
    left join hostel_building T8 on T8.id =T6.buildinglId
    left join hostel T9 on T9.id =T8.hostelId
    left join resources T10 on T10.id =T8.resourceId
    left join resources T11 on T11.id =T9.resourceId
    left join hostel_room_type T12 on T12.id =T5.roomTypeId
	left join users T13 on T13.id =T9.managerId
	left join users T14 on T14.id =T1.allotmentBy
    where T1.id in (namedParams) and T1.allotmentStatus='ALLOTTED'",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_NUMBER",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "resourceName",
            "resultKey": "BUILDING_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "floorNumber",
            "resultKey": "FLOOR_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "roomNumber",
            "resultKey": "ROOM_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "bedNumber",
            "resultKey": "BED_NUMBER",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "resourceName",
            "resultKey": "SU_HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "roomType",
            "resultKey": "ROOM_TYPE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "allotmentDate",
            "resultKey": "ALLOTMENT_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 14,
            "value": "expectedCheckOutDate",
            "resultKey": "AVAILABLE_FROM,",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 15,
            "value": "printName",
            "resultKey": "MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 16,
            "value": "printName",
            "resultKey": "ALLOTMENT_BY",
            "displayCode": "",
            "displayOrder": 11
        }
    ]
}');




SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='STUDENT_HOSTEL_ROOM_ALLOTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='RESIDENCE_ROOM_ALLOTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Hostel Room Allotment Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Hostel Room Allotment Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',TRUE);


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Hostel Room Allotment','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;STUDENT_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LAST_NAME&quot;]</strong>,<br/><br/><strong>$recipientData[&quot;STUDENT_NUMBER&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> We are pleased to inform you that you have been allocated accommodation in Irene residence from <strong>$recipientData[&quot;ALLOTMENT_DATE&quot;].</span></span></p>


			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Hostel Room Allotment','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;STUDENT_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LAST_NAME&quot;]</strong>,<br/><br/><strong>$recipientData[&quot;STUDENT_NUMBER&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> We are pleased to inform you that you have been allocated accommodation in Irene residence from <strong>$recipientData[&quot;ALLOTMENT_DATE&quot;].</span></span></p>


			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["STUDENT_FIRST_NAME"] $recipientData["STUDENT_LAST_NAME"],
$recipientData["STUDENT_NUMBER"]
We are pleased to inform you that you have been allocated accommodation in Irene residence from $recipientData["ALLOTMENT_DATE"].');




-- End Messaging for STUDENT_HOSTEL_ROOM_ALLOTMENT Event

END IF; 

END $$
CALL V20230124124129__Insert_RESIDENCE_ROOM_ALLOTMENT() $$
DROP PROCEDURE IF EXISTS V20230124124129__Insert_RESIDENCE_ROOM_ALLOTMENT $$
DELIMITER ;