DELIMITER $$
DROP PROCEDURE IF EXISTS V20230227210844__Create_StudentFollowup $$
CREATE PROCEDURE V20230227210844__Create_StudentFollowup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_followup')) THEN 
CREATE TABLE `student_followup` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`sgAppointmentId` bigInt(20) DEFAULT NULL,
`studentId` bigint(20) DEFAULT NULL,
`followupSchedule` date DEFAULT NULL,
`followupDate` date DEFAULT NULL,
`followupActivityTypeId` bigint(20) NULL DEFAULT NULL,
`followupReasonId` bigint(20) DEFAULT NULL,
`followupActivityStatusId` bigint(20) NULL DEFAULT NULL,
`followupUserId` bigint(20) DEFAULT NULL,
`remark` text default null,
`followupTime` varchar(255) NULL DEFAULT NULL,
`followupActivityTo` varchar(255) NULL DEFAULT NULL,
`email` varchar(255) default null,
`isdCode` varchar(255) default null,
`mobileNo` bigint(255) default null,
`enqPriorityId` BIGINT(20) NULL DEFAULT NULL,
`scheduleNextFollowupDetail` bit(1) default b'0',
`nextFollowupDate` date DEFAULT NULL,
`assignToId` bigint(20) DEFAULT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
FOREIGN KEY (`sgAppointmentId`) REFERENCES `sg_appointment`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`),
FOREIGN KEY (`followupActivityTypeId`) REFERENCES `follow_up_activity_type`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`followupReasonId`) REFERENCES `reason_for_follow_up`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`followupActivityStatusId`) REFERENCES `follow_up_activity_status`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`followupUserId`) REFERENCES `users`(`id`),
FOREIGN KEY (`enqPriorityId`) REFERENCES `enq_priority`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`assignToId`) REFERENCES `users`(`id`)
);
	
END IF; 

END $$
CALL V20230227210844__Create_StudentFollowup () $$ 
DROP PROCEDURE IF EXISTS V20230227210844__Create_StudentFollowup $$ 
DELIMITER ;