DELIMITER $$
DROP PROCEDURE IF EXISTS V20230411160330__Update_StudentResetPasswordRecipient $$
CREATE PROCEDURE V20230411160330__Update_StudentResetPasswordRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='STUDENT_RESET_PASSWORD_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_RESET_PASSWORD_RECIPIENT');
update sql_dtprovider set sqlQuery = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.code AS LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    T1.resetPassword AS PDF_PASSWORD,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.academyName AS ACADEMY_NAME,
    T8.primaryeEmailId AS ACADEMY_EMAIL,
    T8.websiteURL AS WEBSITE_URL,
     concat(T8.phoneCountryCode,'-',T8.phoneAreaCode,'-',T8.phoneNo) AS PHONE_NUMBER,
    (CASE
        WHEN
            T6.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T6.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T6.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T6.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T6.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T6.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    `users` T1
        INNER JOIN
    `students` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
        LEFT JOIN
    admission T5 ON T5.studentId = T1.id
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_addresses T7 ON T7.academyLocationId = T6.id
        LEFT JOIN
    address T8 ON T8.id = T7.addressId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
     T4.userId IN (namedParams) AND T8.addressTypeId = 10 order by T5.admissionDate desc limit 1" where dataProviderId=@dtproviderId;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='STUDENT_RESET_PASSWORD_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_RESET_PASSWORD_RECIPIENT');
update sql_dtprovider set jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
         {
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },       
        {
            "id": 10,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 9
        },{
            "id": 11,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 10
        },{
            "id": 12,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' where dataProviderId=@dtproviderId;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');
update sql_dtprovider set sqlQuery = "SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code AS LANGUAGE_KEY,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    T2.resetPassword AS PDF_PASSWORD,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.academyName AS ACADEMY_NAME,
T8.primaryeEmailId AS ACADEMY_EMAIL,
     T8.websiteURL AS WEBSITE_URL,
     concat(T8.phoneCountryCode,'-',T8.phoneAreaCode,'-',T8.phoneNo) AS PHONE_NUMBER,
    (CASE
        WHEN
            T6.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T6.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T6.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T6.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T6.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T6.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T6.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    `students` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    multi_language ml ON ml.id = T3.correspondence_language
        LEFT JOIN
    admission T5 ON T5.studentId = T2.id
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_addresses T7 ON T7.academyLocationId = T6.id
        LEFT JOIN
    address T8 ON T8.id = T7.addressId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T2.id IN (namedParams)
        AND T8.addressTypeId = 10
ORDER BY T5.admissionDate DESC
LIMIT 1" where dataProviderId=@dtproviderId;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');
update sql_dtprovider set jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
         {
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },       
        {
            "id": 10,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 9
        },{
            "id": 11,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 10
        },{
            "id": 12,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' where dataProviderId=@dtproviderId;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230411160330__Update_StudentResetPasswordRecipient () $$
DROP PROCEDURE IF EXISTS V20230411160330__Update_StudentResetPasswordRecipient $$
DELIMITER ;