DELIMITER $$
DROP PROCEDURE IF EXISTS `assessmentBasedDetention` $$
CREATE DEFINER=`ss_root`@`%` PROCEDURE `assessmentBasedDetention`()
BEGIN
DECLARE veventId, vmethodId, vsubTypeId, vtypeId, vplanId, vexamResultId, vadmissionId, vcourseVariantId, vperiodId, vsectionId, vrankId, vbatchId BIGINT;
declare base_data_no_more_rows boolean default false;
declare assessment_based_detention_no_more_rows boolean default false;
CREATE TABLE IF NOT EXISTS templog_assessmentBasedDetention (
    msg VARCHAR(512)
);
START TRANSACTION;
BLOCK1: begin
DECLARE base_data CURSOR FOR
select subTypeRank.courseVariantId, subTypeRank.periodId, subTypeRank.sectionId, event.id, subTypeRank.evaluationPlanLevelTwoId, period.programBatchId from evaluation_plan_level_two_rank as subTypeRank
join prog_batch_period_config as period on subTypeRank.periodId = period.id
join eval_seq_detail as event on subTypeRank.evaluationPlanLevelTwoId=event.subTypeLevelEvelDetentionId and event.evaluationBasedDetention = b'1'
join evaluation_sequence as method on event.evalSequenceId = method.id
join evaluation_plan_level_two as subType on method.evalPlanLevelTwoId = subType.id
join evaluation_plan_level_one as type on subType.evalPlanLevelOneId = type.id
join evaluation_type_course as typeCourse on typeCourse.evaluationPlanId=type.evaluationPlanId and typeCourse.courseVariantId=subTypeRank.courseVariantId and typeCourse.periodId = subTypeRank.periodId and typeCourse.sectionId=subTypeRank.sectionId
join course_variant_event_mapping as eventMapping on eventMapping.eventId=event.id and eventMapping.eventStatus = 'PENDING' AND eventMapping.evaluationTypeCourseId=typeCourse.id
left join exam_result_event_students as detenResult on event.id=detenResult.eventId and subTypeRank.admissionId=detenResult.admissionId and subTypeRank.courseVariantId=detenResult.courseVariantId and subTypeRank.periodId=detenResult.periodId and subTypeRank.sectionId=detenResult.sectionId
where upper(subTypeRank.status) <> 'PASS' and detenResult.id is NULL
group by subTypeRank.courseVariantId, subTypeRank.periodId, subTypeRank.sectionId, event.id, subTypeRank.evaluationPlanLevelTwoId;
declare continue handler for not found  set base_data_no_more_rows := true;
OPEN base_data;
base_data: LOOP
fetch base_data into vcourseVariantId, vperiodId, vsectionId, veventId, vrankId, vbatchId;
insert into templog_assessmentBasedDetention values(concat(base_data_no_more_rows,'new data faching vcourseVariantId-',vcourseVariantId,'vperiodId-', vperiodId,'vsectionId-', vsectionId,'veventId-', veventId,'vrankId-',vrankId));
if base_data_no_more_rows then set base_data_no_more_rows := false;
        close base_data;
        leave base_data;
end if;

BLOCK2: begin
DECLARE detention_data CURSOR FOR
select result.id, subTypeRank.admissionId, method.id, subType.id, type.id, type.evaluationPlanId from evaluation_plan_level_two_rank as subTypeRank
join eval_seq_detail as event on subTypeRank.evaluationPlanLevelTwoId=event.subTypeLevelEvelDetentionId and event.evaluationBasedDetention = b'1'
join evaluation_sequence as method on event.evalSequenceId = method.id
join evaluation_plan_level_two as subType on method.evalPlanLevelTwoId = subType.id
join evaluation_plan_level_one as type on subType.evalPlanLevelOneId = type.id
join examination_result as result on event.id=result.evaluationDetailSequenceId and subTypeRank.admissionId=result.admissionId and subTypeRank.courseVariantId=result.courseVariantId and subTypeRank.periodId=result.periodId and subTypeRank.sectionId=result.sectionId and result.reasonForNonDetention is null
left join exam_result_event_students as detenResult on event.id=detenResult.eventId and subTypeRank.admissionId=detenResult.admissionId and subTypeRank.courseVariantId=detenResult.courseVariantId and subTypeRank.periodId=detenResult.periodId and subTypeRank.sectionId=detenResult.sectionId
left join evaluation_type_course as typeCourse on type.evaluationPlanId=typeCourse.evaluationPlanId and typeCourse.courseVariantId=subTypeRank.courseVariantId and typeCourse.periodId = subTypeRank.periodId and typeCourse.sectionId=subTypeRank.sectionId
join course_variant_event_mapping as eventMapping on eventMapping.eventId=event.id and eventMapping.eventStatus = 'PENDING' and eventMapping.evaluationTypeCourseId=typeCourse.id
where upper(subTypeRank.status) <> 'PASS' and detenResult.id is null and subTypeRank.courseVariantId=vcourseVariantId and subTypeRank.periodId=vperiodId and subTypeRank.sectionId=vsectionId and event.id=veventId and subTypeRank.evaluationPlanLevelTwoId=vrankId;
declare continue handler for not found  set assessment_based_detention_no_more_rows := true;
OPEN detention_data;
detention_data: LOOP
fetch detention_data into vexamResultId, vadmissionId, vmethodId, vsubTypeId, vtypeId, vplanId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'Second loop new data faching',vexamResultId));
if assessment_based_detention_no_more_rows then set assessment_based_detention_no_more_rows := false;
        close detention_data;
        leave detention_data;
end if;
-- truncate table templog_assessmentBasedDetention;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'second Data loop start-',vexamResultId));

DELETE FROM examination_result_history 
WHERE
    examinationResultId = vexamResultId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after result history deletion -',vexamResultId));
DELETE FROM examination_result 
WHERE
    id = vexamResultId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after result deletion -',vexamResultId));

delete from evaluation_sequence_rank as mRank where mRank.evaluationSequenceId=vmethodId and mRank.admissionId=vadmissionId and mRank.courseVariantId=vcourseVariantId and mRank.periodId=vperiodId and mRank.sectionId=vsectionId;
delete from evaluation_plan_level_two_rank as mRank where mRank.evaluationPlanLevelTwoId=vsubTypeId and mRank.admissionId=vadmissionId and mRank.courseVariantId=vcourseVariantId and mRank.periodId=vperiodId and mRank.sectionId=vsectionId;
delete from evaluation_plan_level_one_rank as mRank where mRank.evaluationPlanLevelOneId=vtypeId and mRank.admissionId=vadmissionId and mRank.courseVariantId=vcourseVariantId and mRank.periodId=vperiodId and mRank.sectionId=vsectionId;
delete from evaluation_plan_rank as mRank where mRank.evaluationPlanId=vplanId and mRank.admissionId=vadmissionId and mRank.courseVariantId=vcourseVariantId and mRank.periodId=vperiodId and mRank.sectionId=vsectionId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after all rank deletion -',vexamResultId));

delete from marksheet as mRank where mRank.admissionId=vadmissionId and mRank.courseVariantId=vcourseVariantId and mRank.periodId=vperiodId and mRank.sectionId=vsectionId and (mRank.evaluationPlanThreeId=vmethodId or (mRank.evaluationPlanLevelTwoId=vsubTypeId and mRank.evaluationPlanThreeId is null) or (mRank.evaluationPlanLevelOneId=vtypeId and mRank.evaluationPlanLevelTwoId is null) or (mRank.evaluationPlanId=vplanId and mRank.evaluationPlanLevelOneId is null) or (mRank.periodId=vperiodId and mRank.evaluationPlanId is null));

delete from marksheet as mRank where mRank.admissionId=vadmissionId and mRank.periodId is null and mRank.batchId=vbatchId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after all selected marksheet table data deletion -',vexamResultId));

INSERT INTO `exam_result_event_students` (`eventId`, `admissionId`, `courseVariantId`, `sectionId`, `periodId`, `whetherDetention`, `detentionResion`, `lastUpdatedBy`, `lastUpdate`)
VALUES (veventId, vadmissionId, vcourseVariantId, vsectionId, vperiodId, b'1', 'EVALUATION', 1, sysdate());
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after inserting deletion data -',vexamResultId));

UPDATE student_course_enrollment 
SET 
    whetherFailed = NULL,
    marksObtained = NULL,
    whetherPassed = NULL
WHERE
    admissionId = vadmissionId
        AND courseVarientId = vcourseVariantId
        AND programBatchPeriodConfigId = vperiodId
        AND sectionId = vsectionId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after updating enrollment data -',vexamResultId));

delete from evaluation_period_rank mRank where mRank.periodId=vperiodId and mRank.admissionId=vadmissionId;
delete from evaluation_program_rank mRank where mRank.batchId=vbatchId and mRank.admissionId=vadmissionId;
insert into templog_assessmentBasedDetention values(concat(assessment_based_detention_no_more_rows,'after deleting program period rank data -',vadmissionId));
commit;
END LOOP detention_data;
END BLOCK2;
END LOOP base_data;
END BLOCK1;
END$$
DELIMITER ;
