DELIMITER $$
DROP PROCEDURE IF EXISTS V20230504134933__Create_LessonPlanningAssessmentSkill $$
CREATE PROCEDURE V20230504134933__Create_LessonPlanningAssessmentSkill()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lesson_planning_assessment_multi')) THEN 

CREATE TABLE `lesson_planning_assessment_multi` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `LessonPlanExamDetailEventId` BIGINT(20) NOT NULL,
  `lessonPlanningAssessmentTransferredSkillId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_LessonPlanExamDetailEventId_idx` (`LessonPlanExamDetailEventId` ASC),
  INDEX `fk_lessonPlanningAssessmentTransferredSkillId_idx` (`lessonPlanningAssessmentTransferredSkillId` ASC),
  INDEX `fk_lesson_plan_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_lesson_planning_assement_transfer_skill_id`
    FOREIGN KEY (`lessonPlanningAssessmentTransferredSkillId`)
    REFERENCES `lesson_planning_assessment_transferred_skill` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_lesson_plan_exam_detailevent_id`
    FOREIGN KEY (`LessonPlanExamDetailEventId`)
    REFERENCES `event_detail` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_lesson_plan_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20230504134933__Create_LessonPlanningAssessmentSkill () $$ 
DROP PROCEDURE IF EXISTS V20230504134933__Create_LessonPlanningAssessmentSkill $$ 
DELIMITER ;