DELIMITER $$
DROP PROCEDURE IF EXISTS V20230509114840__Create_LearningOutcomeMulti $$
CREATE PROCEDURE V20230509114840__Create_LearningOutcomeMulti()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lesson_planning_assessment_multi_outcome')) THEN 

CREATE TABLE `lesson_planning_assessment_multi_outcome` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `LessonPlanExamDetailEventId` BIGINT(20) NOT NULL,
  `lessonPlanAssessmentLearningOutcomeId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_LessonPlanExamDetailEventIdOutcome_idx` (`LessonPlanExamDetailEventId` ASC),
  INDEX `fk_lessonPlanAssessmentLearningOutcomeId_idx` (`lessonPlanAssessmentLearningOutcomeId` ASC),
  INDEX `fk_lesson_plan_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_lesson_planning_assement_transfer_skill_outcome_id`
    FOREIGN KEY (`lessonPlanAssessmentLearningOutcomeId`)
    REFERENCES `lesson_plan_assessment_learning_outcome` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_lesson_plan_exam_detailevent_id_outcome`
    FOREIGN KEY (`LessonPlanExamDetailEventId`)
    REFERENCES `event_detail` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_lesson_plan_outcome_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20230509114840__Create_LearningOutcomeMulti () $$ 
DROP PROCEDURE IF EXISTS V20230509114840__Create_LearningOutcomeMulti $$ 
DELIMITER ;