DELIMITER $$
DROP PROCEDURE IF EXISTS V20230509171708__Update_InternalExaminerBDataProvider $$
CREATE PROCEDURE V20230509171708__Update_InternalExaminerBDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'INTERNAL_EXAMINER_B_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS internal_examiner_b_first_name,
T4.middleName AS internal_examiner_b_middle_name,
T4.lastName AS internal_examiner_b_last_name,
T4.alternateEmailId AS internal_examiner_b_alternative_email_id,
T4.emailId AS internal_examiner_b_email_id,
T4.phoneNo AS internal_examiner_b_telephone_no,
T4.mobileNumber AS internal_examiner_b_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as internal_examiner_b_address,
T13.code AS internal_examiner_b_id,
T11.salutationName AS internal_examiner_b_title,
T12.itemValue AS internal_examiner_b_gender,
T14.itemValue AS internal_examiner_b_nationality

from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='Internal Examiner B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId"
,resultColumnsDef="internal_examiner_b_first_name,internal_examiner_b_middle_name,internal_examiner_b_last_name,internal_examiner_b_address,internal_examiner_b_email_id,internal_examiner_b_alternative_email_id,internal_examiner_b_telephone_no,internal_examiner_b_mobile_no,internal_examiner_b_id,internal_examiner_b_title,internal_examiner_b_gender,internal_examiner_b_nationality"
WHERE dataSourceCode = 'INTERNAL_EXAMINER_B_INFO';

#------------------TRANSLATIONS---------------------
  
	SET @dydtdatalinitemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='INTERNAL_EXAMINER_B_INFO');
  
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('internal_examiner_b_id', 'Internal Examiner B ID',@dydtdatalinitemId),
    ('internal_examiner_b_title', 'Internal Examiner B Title',@dydtdatalinitemId),
    ('internal_examiner_b_gender', 'Internal Examiner B Gender',@dydtdatalinitemId),
    ('internal_examiner_b_nationality', 'Internal Examiner B Nationality',@dydtdatalinitemId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230509171708__Update_InternalExaminerBDataProvider () $$
DROP PROCEDURE IF EXISTS V20230509171708__Update_InternalExaminerBDataProvider $$
DELIMITER ;