DELIMITER $$
DROP PROCEDURE IF EXISTS V20230511165503__Create_IndepNonExamChairPerofExamiPanel $$
CREATE PROCEDURE V20230511165503__Create_IndepNonExamChairPerofExamiPanel()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='INDEPENDENT_NON-EXAMINING_CHAIRPERSON_OF_EXAMINATION_PANEL_INFO')) THEN 
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'INDEPENDENT_NON-EXAMINING_CHAIRPERSON_OF_EXAMINATION_PANEL_INFO', '1',null, '1', '1', 
"SELECT T1.id AS id,
T4.firstName AS ind_non_exam_char_of_exam_panel_first_name,
T4.middleName AS ind_non_exam_char_of_exam_panel_middle_name,
T4.lastName AS ind_non_exam_char_of_exam_panel_last_name,
T4.alternateEmailId AS ind_non_exam_char_of_exam_panel_alternative_email_id,
T4.emailId AS ind_non_exam_char_of_exam_panel_email_id,
T4.phoneNo AS ind_non_exam_char_of_exam_panel_telephone_no,
T4.mobileNumber AS ind_non_exam_char_of_exam_panel_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS ind_non_exam_char_of_exam_panel_address,
T13.code AS ind_non_exam_char_of_exam_panel_id,
T11.salutationName AS ind_non_exam_char_of_exam_panel_title,
T12.itemValue AS ind_non_exam_char_of_exam_panel_gender,
T15.deptName AS ind_non_exam_char_of_exam_panel_department
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join department T15 on T15.id =T5.departmentId"
,
    'PRM_ADMISSION_ID', 'ind_non_exam_char_of_exam_panel_first_name,ind_non_exam_char_of_exam_panel_middle_name,ind_non_exam_char_of_exam_panel_last_name,ind_non_exam_char_of_exam_panel_address,ind_non_exam_char_of_exam_panel_email_id,ind_non_exam_char_of_exam_panel_alternative_email_id,ind_non_exam_char_of_exam_panel_telephone_no,ind_non_exam_char_of_exam_panel_mobile_no,ind_non_exam_char_of_exam_panel_id,ind_non_exam_char_of_exam_panel_title,ind_non_exam_char_of_exam_panel_gender,ind_non_exam_char_of_exam_panel_department',
    "WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='INDEPENDENT NON-EXAMINING CHAIRPERSON OF EXAMINATION PANEL' order by T3.id  desc limit 1;",'0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('ind_non_exam_char_of_exam_panel_first_name', 'Independent Non-Examining Chairperson of Examination Panel First Name',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_middle_name', 'Independent Non-Examining Chairperson of Examination Panel Middle Name',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_last_name', 'Independent Non-Examining Chairperson of Examination Panel Last Name',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_address', 'Independent Non-Examining Chairperson of Examination Panel Address',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_email_id', 'Independent Non-Examining Chairperson of Examination Panel Email ID',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_alternative_email_id', 'Independent Non-Examining Chairperson of Examination Panel Alternative Email ID',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_telephone_no', 'Independent Non-Examining Chairperson of Examination Panel Telephone No.',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_mobile_no', 'Independent Non-Examining Chairperson of Examination Panel Mobile No.',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_id', 'Independent Non-Examining Chairperson of Examination Panel ID',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_title', 'Independent Non-Examining Chairperson of Examination Panel Title',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_gender', 'Independent Non-Examining Chairperson of Examination Panel Gender',@dydtdatalinitemId+1),
    ('ind_non_exam_char_of_exam_panel_department', 'Independent Non-Examining Chairperson of Examination Panel Department',@dydtdatalinitemId+1);
    
END IF; 
END $$
CALL V20230511165503__Create_IndepNonExamChairPerofExamiPanel () $$ 
DROP PROCEDURE IF EXISTS V20230511165503__Create_IndepNonExamChairPerofExamiPanel $$ 
DELIMITER ;