DELIMITER $$
DROP PROCEDURE IF EXISTS V20230614124930__Insert_ANANTU_RECEIPT_SETTLEMENT_STUDENT $$
CREATE PROCEDURE V20230614124930__Insert_ANANTU_RECEIPT_SETTLEMENT_STUDENT()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt With Settlement' );

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' and `templateName`='AnantU(Outstanding Balance) Receipt with Settlement - Student End')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'AnantU(Outstanding Balance) Receipt with Settlement - Student End', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_ANANTU.png', 'CommonReport_Anantu.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RECEIPT_WITH_SETTLEMENT_STUDENT_CODE_ANANTU.jasper', 'AcademiaLogo.jpg');
END IF;

set @rID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_MOBILE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_MOBILE', 'Student Mobile', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PROGRAM', 'Program Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_CURRENT_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_CURRENT_PERIOD', 'Current Period', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT_NO', 'Receipt No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPT_DATE', 'Receipt Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ADMISSION_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ADMISSION_DATE', 'Admission Date', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BATCH_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BATCH_NAME', 'Batch Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FEE_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FEE_HEAD', 'Fee Head', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FEE_HEAD_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FEE_HEAD_AMOUNT', 'Fee Head Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SCHOLARSHIP_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SCHOLARSHIP_AMOUNT', 'Scholarship Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PAYABLE_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PAYABLE_AMOUNT', 'Payable Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_PAID_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_PAID_AMOUNT', 'Paid Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_AMOUNT', 'Total', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT_RECEIVED_IN_WORDS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT_RECEIVED_IN_WORDS', 'Amount Received in words', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TRANSACTION_TYPE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TRANSACTION_TYPE', 'Transaction Type', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_INSTRUMENT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_INSTRUMENT_NO', 'Instrument No', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_INSTRUMENT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_INSTRUMENT_DATE', 'Instrument Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BANK_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BANK_NAME', 'Bank Name', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT_RECEIVED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT_RECEIVED', 'Amount Received', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_OUTSTANDING_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_OUTSTANDING_DETAILS', 'Outstanding details', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FEE_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FEE_HEAD', 'Fee Head', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FEE_HEAD_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FEE_HEAD_AMOUNT', 'Fee Head Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL', 'Total', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TERMS_AND_CONDITION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TERMS_AND_CONDITION', 'Terms and conditions', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ANANTU_POINT_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ANANTU_POINT_ONE', 'This is an original receipt and shall be issued once.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ANANTU_POINT_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ANANTU_POINT_TWO', 'Demand Draft, Pay Order, Bankers Cheques are subject to realization.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ANANTU_POINT_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ANANTU_POINT_THREE', 'Fee once received is refundable as per the refund policy & rules of the university.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ANANTU_POINT_FOUR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ANANTU_POINT_FOUR', 'All disputes are subject to ahmedabad Jurisdiction only.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ANANTU_POINT_FIVE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ANANTU_POINT_FIVE', 'Please check receipt particulars before leaving the counter.', '1', now());
END IF;

END $$
CALL V20230614124930__Insert_ANANTU_RECEIPT_SETTLEMENT_STUDENT() $$
DROP PROCEDURE IF EXISTS V20230614124930__Insert_ANANTU_RECEIPT_SETTLEMENT_STUDENT $$
DELIMITER ;