DROP procedure IF EXISTS `getNotSyncStudents_To_Koha`;

DELIMITER $$

CREATE PROCEDURE `getNotSyncStudents_To_Koha`(userTypeId_var int(10))
BEGIN

SELECT 
    IFNULL(person1_.lastName, ''),
    IFNULL(person1_.firstName, ''),
    person1_.birthDate,
    person1_.shortName,
    person1_.printName,
    IF(person1_.gender = 'MALE', 'M', 'F'),
    CONCAT(IFNULL(CONCAT(person1_.phoneAreaCode, ' '), ''),
            IFNULL(CONCAT(person1_.phoneAreaCode, ' '), ''),
            IFNULL(CONCAT(person1_.PhoneNo, ' '), '')) AS phonepro_,
    CONCAT(IFNULL(CONCAT(person1_.mobileCountryCode, ' '),
                    ''),
            IFNULL(CONCAT(person1_.mobileNumber, ' '), '')) AS MobileCountryCode,
    person1_.emailId,
    person1_.alternateEmailId,
    IF(cardnomapp9_.libraryCardNumberType = 'Student ID',
        this_1_.code,
        admission10_.CODE) AS studentadmissioncode,
     program14_.programNameToBePrint AS sort1,
    CONCAT(CONCAT(batch13_.printName, '%'),
            programbat12_.printName) AS sort2,
    DATE(admission10_.admissionDate),
    DATE(person1_.validTill),
    this_1_.code,
    address1_.addressText,
    address1_.pincode,
    city3_.cityName,
    parentregi2_.countryRegionName,
    country4_.countryName,
    address1_.primaryeEmailId,
    CONCAT(IFNULL(address1_.cellCountryCode, ' '),
            '',
            CONCAT(IFNULL(address1_.phoneAreaCode, ' '), ''),
            CONCAT(IFNULL(address1_.phoneNo, ' '), '')) AS b_phonepro_,
    CONCAT(IFNULL(CONCAT(address1_.cellCountryCode, ' '),
                    ''),
            IFNULL(CONCAT(address1_.phoneAreaCode, ' '), ''),
            CONCAT(IFNULL(address1_.phoneNo, ' '), '')) AS b_phonepro1_,
    IFNULL(categories7_.categoryCode, '02'),
    IFNULL(branch5_.branchCode, '01'),
    'inherit',
    '0',
    '1',
    salutation2_.salutationName,
    this_.personId AS personId,
    this_1_.id AS userId,
    '$2a$08$5/NpsPcUdQvIUTPxgtXc7..aNlAcvUqN0GwfJh9lJgbM5inGCzZ..',
    IFNULL(person1_.photoUrl, ''),
    address2_.addressText AS bAddressText,
    city32_.cityName AS bCity,
    parentregi22_.countryRegionName AS bcountryRegionName,
    country42_.countryName AS bcountryName,
    address2_.pincode AS bPincode
FROM
    students this_
        INNER JOIN
    users this_1_ ON this_.userId = this_1_.id
        LEFT OUTER JOIN
    academia_koha_sync academicko3_ ON this_.userId = academicko3_.userId
        LEFT OUTER JOIN
    user_groups usergroup8_ ON this_1_.userGroupId = usergroup8_.id
        LEFT OUTER JOIN
    library_card_number_mapping cardnomapp9_ ON usergroup8_.id = cardnomapp9_.userTypeId
        LEFT OUTER JOIN
    koha_user_category_mapping usercatego6_ ON this_.userId = usercatego6_.userId
        LEFT OUTER JOIN
    academy_location_koha_category ualkc ON  ualkc.id =   usercatego6_.academyLocKohaCategoryId 
        LEFT OUTER JOIN
    koha_categories categories7_ ON ualkc.categoryId = categories7_.id
        LEFT OUTER JOIN
    koha_user_library_mapping userlibrar4_ ON this_.userId = userlibrar4_.userId
        LEFT OUTER JOIN
    academy_location_koha_branch alkb  ON alkb.id = userlibrar4_.academyLocKohaBranchId 
        LEFT OUTER JOIN
    koha_branches branch5_ ON alkb.branchId = branch5_.id
        LEFT OUTER JOIN
    admission admission10_ ON this_.userId = admission10_.studentId
        LEFT OUTER JOIN
    program_batch_students programbat11_ ON admission10_.id = programbat11_.admissionId
        LEFT OUTER JOIN
    prog_batch_period_config programbat12_ ON programbat11_.progBatchPeriodConfigId = programbat12_.id
        LEFT OUTER JOIN
    batches batch13_ ON programbat12_.programBatchId = batch13_.id
        LEFT OUTER JOIN
    programs program14_ ON batch13_.programId = program14_.id
    left outer join persons person1_ on this_.personId=person1_.id 
        LEFT OUTER JOIN
    person_addresses person_add1_ ON person1_.id = person_add1_.personId
        AND person_add1_.addressTypeId = 5
        LEFT OUTER JOIN
    address address1_ ON person_add1_.addressId = address1_.id
        LEFT OUTER JOIN
    address_type addresstyp5_ ON person_add1_.addressTypeId = addresstyp5_.id
        LEFT OUTER JOIN
    city city3_ ON address1_.cityId = city3_.id
        LEFT OUTER JOIN
    country_region parentregi2_ ON address1_.parentRegionId = parentregi2_.id
        LEFT OUTER JOIN
    country country4_ ON parentregi2_.countryId = country4_.id
        LEFT OUTER JOIN
    person_addresses person_add2_ ON person1_.id = person_add2_.personId
        AND person_add2_.addressTypeId = 7
        LEFT OUTER JOIN
    address address2_ ON person_add2_.addressId = address2_.id
        LEFT OUTER JOIN
    address_type addresstyp52_ ON person_add2_.addressTypeId = addresstyp52_.id
        LEFT OUTER JOIN
    city city32_ ON address2_.cityId = city32_.id
        LEFT OUTER JOIN
    country_region parentregi22_ ON address2_.parentRegionId = parentregi22_.id
        LEFT OUTER JOIN
    country country42_ ON parentregi22_.countryId = country42_.id
        LEFT OUTER JOIN
    id_type idtype29_ ON person1_.idTypeId = idtype29_.id
        LEFT OUTER JOIN
    drop_down dropdown30_ ON person1_.areaOfResearch = dropdown30_.id
        LEFT OUTER JOIN
    multi_language multilangu31_ ON person1_.contact_language = multilangu31_.id
        LEFT OUTER JOIN
    multi_language multilangu32_ ON person1_.correspondence_language = multilangu32_.id
        LEFT OUTER JOIN
    drop_down dropdown33_ ON person1_.currentEducationalInterventions = dropdown33_.id
        LEFT OUTER JOIN
    drop_down dropdown34_ ON person1_.fieldOfInterest = dropdown34_.id
        LEFT OUTER JOIN
    gender gendercsm35_ ON person1_.genderId = gendercsm35_.id
        LEFT OUTER JOIN
    drop_down dropdown36_ ON person1_.haveDisabilities = dropdown36_.id
        LEFT OUTER JOIN
    drop_down dropdown37_ ON person1_.homeLanguage = dropdown37_.id
        LEFT OUTER JOIN
    person_cd personcust38_ ON person1_.id = personcust38_.personId
        LEFT OUTER JOIN
    salutations salutation2_ ON person1_.salutationId = salutation2_.id
        LEFT OUTER JOIN
    drop_down dropdown40_ ON person1_.secondLanguage = dropdown40_.id
        LEFT OUTER JOIN
    nationalities nationalit41_ ON person1_.secondary_citizenship = nationalit41_.id 
WHERE
    admission10_.code is not null AND
    admission10_.activeStatus = TRUE
        AND this_1_.status = TRUE
        AND programbat11_.exitDate IS NULL
        AND cardnomapp9_.userTypeId = 3
        AND (academicko3_.status IS NULL
        OR academicko3_.status = 'Pending')
GROUP BY this_.personId; 


END$$

DELIMITER ;