DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726153731__Create_LanguageDocumentUrl $$
CREATE PROCEDURE V20230726153731__Create_LanguageDocumentUrl()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='language_document_url')) THEN 
CREATE TABLE language_document_url(  
  id BIGINT(20) NOT NULL AUTO_INCREMENT,
  studentLanguageId BIGINT(20) NOT NULL,
  documentName varchar(255) DEFAULT NULL,
  documentUrl varchar(255) DEFAULT NULL,  
  lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  lastUpdatedBy BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `language_document_url_FK` FOREIGN KEY (`studentLanguageId`) REFERENCES student_language(`id`),
  CONSTRAINT `language_document_url_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`));
END IF; 

END $$
CALL V20230726153731__Create_LanguageDocumentUrl () $$ 
DROP PROCEDURE IF EXISTS V20230726153731__Create_LanguageDocumentUrl $$ 
DELIMITER ;