DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726171012__Insert_DMUK_Emp_Idcard $$
CREATE PROCEDURE V20230726171012__Insert_DMUK_Emp_Idcard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'DMUK_EMPLOYEE_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'DMUK_EMPLOYEE_ID_CARD', 'DMUK-Employee ID Card', 'id_card_front.png', 'CommonReport_EMPLOYEE_ID_CARD_DMUK.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'DMUK-Employee ID Card.jasper', 'AcademiaLogo.png');
END IF; 

set @DMUK_EMPLOYEE_ID_CARD = (select max(id) from report_template where templateCode ='DMUK_EMPLOYEE_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='DMUK_EMPLOYEE_ID_CARD'  and keyValue='TRANS_STAFF_PASS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@DMUK_EMPLOYEE_ID_CARD, 'TRANS_STAFF_PASS', 'STAFF PASS', '1', NOW());
END IF;

END $$
CALL V20230726171012__Insert_DMUK_Emp_Idcard() $$
DROP PROCEDURE IF EXISTS V20230726171012__Insert_DMUK_Emp_Idcard $$
DELIMITER ;