DELIMITER $$
DROP PROCEDURE IF EXISTS V20230727182254__Insert_Student_IDCard_DMUK $$
CREATE PROCEDURE V20230727182254__Insert_Student_IDCard_DMUK()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENT_ID_CARD_DMUK')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'STUDENT_ID_CARD_DMUK', 'DMUK Student Id card', 'STUDENT_ID_CARD_DMUK.png', 'CommonReport_STUDENT_ID_CARD_DMUK.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'STUDENT_ID_CARD_DMUK.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STUDENT_ID_CARD_DMUK'))) THEN
	set @studentIDCard = (select id from report_template where templateCode ='STUDENT_ID_CARD_DMUK');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@studentIDCard, 'TRANS_STUDENT', 'STUDENT', '1', NOW()),
	 (@studentIDCard, 'TRANS_CARD_EXPIRY', 'CARD EXPIRY:', '1', NOW()),
	 (@studentIDCard, 'TRANS_BATCH', 'BATCH:', '1', NOW()),
	 (@studentIDCard, 'TRANS_DMU_ID', 'DMU ID:', '1', NOW()),
	 (@studentIDCard, 'TRANS_DMUK_ID', 'DMUK ID:', '1', NOW()),
	 (@studentIDCard, 'TRANS_DMUK_STUDENT_SERVICE', 'DMUK STUDENT SERVICE:', '1', NOW()),
	 (@studentIDCard, 'TRANS_+7', '+7', '1', NOW()),
	 (@studentIDCard, 'TRANS_727', '727', '1', NOW()),
	 (@studentIDCard, 'TRANS_339', '339', '1', NOW()),
	 (@studentIDCard, 'TRANS_0090', '0090', '1', NOW());
	 INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`,`customValue`, `lastUpdatedBy`, `lastUpdate`)
	 values (@studentIDCard,  'TRANS_SUMMARY','Summary', 'This card must be carried at all times whilst on University premises. You are responsible for your ID card. If you lose your card inform Student Services and Library immediately. The card remains the property of the University and must be surrendered to any authorised officer of the University on request. The card must not be given to any other student or individual. Any person found in possession of an ID card that does not belong to them, will have the card confiscated and they (and the card owner) could be subject to University disciplinary proceedings', '1', NOW());
  END IF;
END $$
CALL V20230727182254__Insert_Student_IDCard_DMUK() $$
DROP PROCEDURE IF EXISTS V20230727182254__Insert_Student_IDCard_DMUK $$
DELIMITER ;