DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728133431__Create_scholarshipRaiseRequest $$
CREATE PROCEDURE V20230728133431__Create_scholarshipRaiseRequest()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_raise_request' )) THEN 
CREATE TABLE scholarship_raise_request (
id bigint(20) NOT NULL AUTO_INCREMENT,
studentId bigint(20) DEFAULT NULL,
applicantId bigint(20) DEFAULT NULL,
admissionId bigint(20) DEFAULT NULL,
programBatchSeatConfigId bigint(20) DEFAULT NULL,
requesterType varchar(20) DEFAULT NULL,
requestBy bigint(20) DEFAULT NULL,
requestDate Date DEFAULT NULL,
assignedTo bigint(20) DEFAULT NULL,
scholarshipId bigint(20) DEFAULT NULL,
finacialYearId bigint(20) DEFAULT NULL,
workStatus varchar(6)  DEFAULT NULL,
isTaxLiable bit(1) DEFAULT NULL,
isDoingNowork bit(1) DEFAULT NULL,
isSubsequentBusary bit(1) DEFAULT NULL,
studentFees double(20,3) DEFAULT NULL,
accomondationFees double(20,3) DEFAULT NULL,
otherFees double(20,3) DEFAULT NULL,
totalScholarshipAmount double(25,3) DEFAULT NULL,
remark varchar(250) DEFAULT NULL,
requestStatus varchar(30) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (id),
FOREIGN KEY (studentId) REFERENCES students (userId),
FOREIGN KEY (applicantId) REFERENCES application (id),
FOREIGN KEY (admissionId) REFERENCES admission (id),
FOREIGN KEY (programBatchSeatConfigId) REFERENCES prog_batch_seat_config(id),
FOREIGN KEY (requestBy) REFERENCES users (id),
FOREIGN KEY (assignedTo) REFERENCES users (id),
FOREIGN KEY (scholarshipId) REFERENCES scholarship (id),
FOREIGN KEY (finacialYearId) REFERENCES accounting_year (id),
FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);
END IF; 

END $$
CALL V20230728133431__Create_scholarshipRaiseRequest () $$ 
DROP PROCEDURE IF EXISTS V20230728133431__Create_scholarshipRaiseRequest $$ 
DELIMITER ;