DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801102302__Create_scholarship_accounting_setup $$
CREATE PROCEDURE V20230801102302__Create_scholarship_accounting_setup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_accounting_setup')) THEN 
CREATE TABLE `scholarship_accounting_setup` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `accountingYearId` BIGINT NOT NULL,
  `scholarshipBudgetAmount` double(20,2) NOT NULL,
  `scholarshipBalanceAmount` double(20,2) NOT NULL,
  `basedType` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_scholarship_accounting_setup_to_scholarship_idx`(`scholarshipId`),
  INDEX `fk_scholarship_accounting_setup_to_accountingYear_idx` (`accountingYearId`),
  INDEX `fk_scholarship_accounting_setup_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_scholarship_accounting_setup_to_scholarship` 
	FOREIGN KEY (`scholarshipId`) 
	REFERENCES `scholarship`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_scholarship_accounting_setup_to_accountingYear`
	FOREIGN KEY (`accountingYearId`)
	REFERENCES `accounting_year` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_scholarship_accounting_setup_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 
END $$
CALL V20230801102302__Create_scholarship_accounting_setup () $$ 
DROP PROCEDURE IF EXISTS V20230801102302__Create_scholarship_accounting_setup $$ 
DELIMITER ;