DELIMITER $$
DROP PROCEDURE IF EXISTS V20230804120531__Insert_HostelApplicationDataGrid $$
CREATE PROCEDURE V20230804120531__Insert_HostelApplicationDataGrid()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.services.HostelApplicationDetailsView' AND portalId=3))  THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.personinfo.common.services.HostelApplicationDetailsView',3, '[
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocation","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"HOSTEL_CODE_NAME","dataIndex":"hostel","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"APPLICATION_STATUS","dataIndex":"applicationStatus","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"ALLOCATED_HOSTEL","dataIndex":"allocatedHostel","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"APPLICATION_TYPE","dataIndex":"hostelSetupType","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"WAITITNG_LIST_ID_NAME","dataIndex":"hostelApplicationSetup","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"YEAR_OF_APPLICATION","dataIndex":"yearOfApplication","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"WANT_REALLOCATE_SAME_HOSTEL","dataIndex":"isReAllocateInSameHostel","totalBursaryAmount":"SHOW","sequence":8,"mandatory":false}]',
now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='ALLOCATED_HOSTEL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'ALLOCATED_HOSTEL', 'Allocated Hostel', 'Allocated Hostel', 'Toegewys koshuis', 'Ký túc xá được phân bổ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='WAITITNG_LIST_ID_NAME')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'WAITITNG_LIST_ID_NAME', 'Waititng List ID/Name', 'Waititng List ID/Name', 'Waglys ID/naam', 'Danh sách chờ ID/Tên',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='YEAR_OF_APPLICATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'YEAR_OF_APPLICATION', 'Year of Application', 'Year of Application', 'Jaar van Aansoek', 'Năm áp dụng',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='WANT_REALLOCATE_SAME_HOSTEL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'WANT_REALLOCATE_SAME_HOSTEL', 'Want Reallocate in Same hostel?', 'Want Reallocate in Same hostel?', 'Wil jy hertoewys in dieselfde koshuis?', 'Muốn phân bổ lại trong cùng một ký túc xá?',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='APPLY_FOR_HOSTEL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'APPLY_FOR_HOSTEL', 'Apply for Hostel', 'Apply for Hostel', 'Doen aansoek vir koshuis', 'Đăng ký ký túc xá',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='APPLY_FOR_WAITING_LIST')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'APPLY_FOR_WAITING_LIST', 'Apply for Waiting List', 'Apply for Waiting List', 'Doen aansoek vir waglys', 'Đăng ký danh sách chờ',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='HOSTEL' AND keyName='REVOKE_APPLICATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('HOSTEL', 'REVOKE_APPLICATION', 'Revoke Application', 'Revoke Application', 'Herroep aansoek', 'Thu hồi ứng dụng',now(),1);
END IF; 


END $$
CALL V20230804120531__Insert_HostelApplicationDataGrid() $$
DROP PROCEDURE IF EXISTS V20230804120531__Insert_HostelApplicationDataGrid $$
DELIMITER ;