DELIMITER $$
DROP PROCEDURE IF EXISTS V20230822171513__Create_scholarship_nominate_or_award $$
CREATE PROCEDURE V20230822171513__Create_scholarship_nominate_or_award()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_nominate_or_award' )) THEN 
CREATE TABLE scholarship_nominate_or_award (
id bigint(20) NOT NULL AUTO_INCREMENT,
scholarshipId bigint(20) DEFAULT NULL,
code bigint(200) NOT NULL,
studentId bigint(20) DEFAULT NULL,
applicantId bigint(20) DEFAULT NULL,
applicableFor varchar(20) DEFAULT NULL,
accountingYearId bigint(20) DEFAULT NULL,
programId bigint(20) DEFAULT NULL,
batchId bigint(20) DEFAULT NULL,
amount double(20,3) DEFAULT NULL,
status varchar(30) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (id),
FOREIGN KEY (scholarshipId) REFERENCES scholarship (id),
FOREIGN KEY (studentId) REFERENCES students (userId),
FOREIGN KEY (applicantId) REFERENCES application (id),
FOREIGN KEY (accountingYearId) REFERENCES accounting_year (id),
FOREIGN KEY (programId) REFERENCES programs (id),
FOREIGN KEY (batchId) REFERENCES batches (id),
FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);
END IF; 

END $$
CALL V20230822171513__Create_scholarship_nominate_or_award () $$ 
DROP PROCEDURE IF EXISTS V20230822171513__Create_scholarship_nominate_or_award $$ 
DELIMITER ;