DELIMITER $$
DROP PROCEDURE IF EXISTS V20240124165023__Create_periodpromotioncriteriaCourse $$
CREATE PROCEDURE V20240124165023__Create_periodpromotioncriteriaCourse()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='period_promotion_criteria_courses')) THEN 
create table period_promotion_criteria_courses(id BIGINT(20) NOT NUll auto_increment primary key,
`periodPromotionCriteriaId` BIGINT(20) Default Null,
`periodId` BIGINT(20) Default Null,
`courseId` BIGINT(20) Default Null,
`lastUpdatedBy` BIGINT(20) NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
INDEX `period_promotion_criteria_idx` (`periodPromotionCriteriaId` ASC),
INDEX  `period_id_idx` (`periodId` ASC),
INDEX  `course_id_idx` (`courseId` ASC),
INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
CONSTRAINT `child_periodPromotionCriteria_id` FOREIGN KEY (`periodPromotionCriteriaId`)
REFERENCES `period_promotion_criteria` (`id`),
CONSTRAINT `child_period_id` FOREIGN KEY (`periodId`)
REFERENCES `prog_batch_period_config` (`id`),
CONSTRAINT `child_course_id` FOREIGN KEY (`courseId`)
REFERENCES `courses` (`id`),
FOREIGN KEY (`lastUpdatedBy`) 
REFERENCES `users` (`id`)
ON DELETE RESTRICT
ON UPDATE RESTRICT); 
END IF;
END $$
CALL V20240124165023__Create_periodpromotioncriteriaCourse () $$ 
DROP PROCEDURE IF EXISTS V20240124165023__Create_periodpromotioncriteriaCourse $$ 
DELIMITER ;