DELIMITER $$
DROP PROCEDURE IF EXISTS V20240213125549__Update_Add_Campus_year_RESIDENCE_ALLOTMENT $$
CREATE PROCEDURE V20240213125549__Update_Add_Campus_year_RESIDENCE_ALLOTMENT()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_CHECK_IN_RCPNT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_CHECK_IN_RCPNT');
 UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T3.code as STUDENT_ID,
    T3.firstName as STUDENT_FIRST_NAME,
	T3.firstName as FIRST_NAME,
	T3.printName as PRINT_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T3.printName AS STUDENT_PRINT_NAME,
    T4.emailId as EMAIL_ID,
    T4.mobileCountryCode as MOBILE_CODE,
    T4.mobileNumber as MOBILE_NO,
    T10.resourceName as BUILDING_NAME,
    T6.floorNumber as FLOOR_NAME,
    T5.roomNumber as ROOM_NUMBER,
    T7.bedNumber as BED_NUMBER,
    T11.resourceName as SU_HOSTEL_NAME,
    T11.code as HOSTEL_CODE,
    T12.roomType as ROOM_TYPE,
    T1.checkInDate as CHECK_IN_DATE,
    T1.expectedCheckOutDate as EXPECTED_CHECK_OUT_DATE,
    T13.printName as MANAGER_NAME,
    T14.printName as WARDER_NAME,
    T17.itemValue as ACADEMIC_TERM,
    T20.locationName as CAMPUS
FROM
    hostel_room_allotment T1
    left join students T2 on T2.userId =T1.studentId
    left join users T3 on T3.id =T2.userId
    left join persons T4 on T4.id =T2.personId
    left join hostel_room T5 on T5.id =T1.roomId
    left join hostel_floor T6 on T6.id =T5.floorId
    left join hostel_bed T7 on T7.id =T1.bedId 
    left join hostel_building T8 on T8.id =T6.buildinglId
    left join hostel T9 on T9.id =T8.hostelId
    left join resources T10 on T10.id =T8.resourceId
    left join resources T11 on T11.id =T9.resourceId
    left join hostel_room_type T12 on T12.id =T5.roomTypeId
	left join users T13 on T13.id =T9.managerId
	left join users T14 on T14.id =T9.wardenId
    left join student_hostel_application T15 on T1.id=T15.allottedHostelRoomAllotmentId
    left join hostel_application_setup T16 on T16.id=T15.hostelApplicationSetupId
    left join academic_term T17 on T17.id=T16.year
    left join internal_resources T18 on T11.id =T18.resourceId
    left join resource_academy_locations T19 on T19.id =T18.resourceAcademyLocationId
    left join academy_location T20 on T20.id=T19.academyLocationId
    where T1.id in (namedParams)" , 
    `jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "resourceName",
            "resultKey": "BUILDING_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "floorNumber",
            "resultKey": "FLOOR_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "roomNumber",
            "resultKey": "ROOM_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "bedNumber",
            "resultKey": "BED_NUMBER",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "resourceName",
            "resultKey": "SU_HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "roomType",
            "resultKey": "ROOM_TYPE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "checkInDate",
            "resultKey": "CHECK_IN_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 14,
            "value": "expectedCheckOutDate",
            "resultKey": "EXPECTED_CHECK_OUT_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 15,
            "value": "printName",
            "resultKey": "MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 16,
            "value": "printName",
            "resultKey": "WARDER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
{
            "id": 17,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },
{
            "id": 18,
            "value": "locationName",
            "resultKey": "CAMPUS",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}'
WHERE  dataProviderId =@residenceRCPNT;
 
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_CHECK_OUT_RCPNT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_CHECK_OUT_RCPNT');
 UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T3.code as STUDENT_ID,
    T3.firstName as STUDENT_FIRST_NAME,
	T3.firstName as FIRST_NAME,
	T3.printName as PRINT_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T3.printName AS STUDENT_PRINT_NAME,
    T4.emailId as EMAIL_ID,
    T4.mobileCountryCode as MOBILE_CODE,
    T4.mobileNumber as MOBILE_NO,
    T10.resourceName as BUILDING_NAME,
    T6.floorNumber as FLOOR_NAME,
    T5.roomNumber as ROOM_NUMBER,
    T7.bedNumber as BED_NUMBER,
    T11.resourceName as SU_HOSTEL_NAME,
    T11.code as HOSTEL_CODE,
    T12.roomType as ROOM_TYPE,
    T1.checkInDate as CHECK_IN_DATE,
    T1.expectedCheckOutDate as EXPECTED_CHECK_OUT_DATE,
    T13.printName as MANAGER_NAME,
    T14.printName as WARDER_NAME,
    T1.financialActualCheckOutDate as ACTUAL_FINANCIAL_CHECKOUT_DATE,
 T17.itemValue as ACADEMIC_TERM,
    T20.locationName as CAMPUS
FROM
    hostel_room_allotment T1
    left join students T2 on T2.userId =T1.studentId
    left join users T3 on T3.id =T2.userId
    left join persons T4 on T4.id =T2.personId
    left join hostel_room T5 on T5.id =T1.roomId
    left join hostel_floor T6 on T6.id =T5.floorId
    left join hostel_bed T7 on T7.id =T1.bedTemp
    left join hostel_building T8 on T8.id =T6.buildinglId
    left join hostel T9 on T9.id =T8.hostelId
    left join resources T10 on T10.id =T8.resourceId
    left join resources T11 on T11.id =T9.resourceId
    left join hostel_room_type T12 on T12.id =T5.roomTypeId
	left join users T13 on T13.id =T9.managerId
	left join users T14 on T14.id =T9.wardenId
	left join student_hostel_application T15 on T1.id=T15.allottedHostelRoomAllotmentId
    left join hostel_application_setup T16 on T16.id=T15.hostelApplicationSetupId
    left join academic_term T17 on T17.id=T16.year
    left join internal_resources T18 on T11.id =T18.resourceId
    left join resource_academy_locations T19 on T19.id =T18.resourceAcademyLocationId
    left join academy_location T20 on T20.id=T19.academyLocationId
    where T1.id in (namedParams) and T1.allotmentStatus='CHECKED_OUT'" , 
    `jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "resourceName",
            "resultKey": "BUILDING_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "floorNumber",
            "resultKey": "FLOOR_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "roomNumber",
            "resultKey": "ROOM_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "bedNumber",
            "resultKey": "BED_NUMBER",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "resourceName",
            "resultKey": "SU_HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "roomType",
            "resultKey": "ROOM_TYPE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "checkInDate",
            "resultKey": "CHECK_IN_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 14,
            "value": "expectedCheckOutDate",
            "resultKey": "EXPECTED_CHECK_OUT_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 15,
            "value": "printName",
            "resultKey": "MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 16,
            "value": "printName",
            "resultKey": "WARDER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 17,
            "value": "financialActualCheckOutDate",
            "resultKey": "ACTUAL_FINANCIAL_CHECKOUT_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
{
            "id": 18,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },
{
            "id": 19,
            "value": "locationName",
            "resultKey": "CAMPUS",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}'
 WHERE  dataProviderId =@residenceRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_ROOM_ALLOTMENT_RCPNT');
 UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T3.code as STUDENT_NUMBER,
    T3.firstName as STUDENT_FIRST_NAME,
	T3.firstName as FIRST_NAME,
	T3.printName as PRINT_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T3.printName AS STUDENT_PRINT_NAME,
    T4.emailId as EMAIL_ID,
    T4.mobileCountryCode as MOBILE_CODE,
    T4.mobileNumber as MOBILE_NO,
    T10.resourceName as BUILDING_NAME,
    T6.floorNumber as FLOOR_NAME,
    T5.roomNumber as ROOM_NUMBER,
    T7.bedNumber as BED_NUMBER,
    T11.resourceName as SU_HOSTEL_NAME,
    T11.code as HOSTEL_CODE,
    T12.roomType as ROOM_TYPE,
    T1.allotmentDate as ALLOTMENT_DATE,
    T1.expectedCheckOutDate as AVAILABLE_FROM,
    T13.printName as MANAGER_NAME,
    T14.printName as ALLOTMENT_BY,
T17.itemValue as ACADEMIC_TERM,
    T20.locationName as CAMPUS
FROM
    hostel_room_allotment T1
    left join students T2 on T2.userId =T1.studentId
    left join users T3 on T3.id =T2.userId
    left join persons T4 on T4.id =T2.personId
    left join hostel_room T5 on T5.id =T1.roomId
    left join hostel_floor T6 on T6.id =T5.floorId
    left join hostel_bed T7 on T7.id =T5.id
    left join hostel_building T8 on T8.id =T6.buildinglId
    left join hostel T9 on T9.id =T8.hostelId
    left join resources T10 on T10.id =T8.resourceId
    left join resources T11 on T11.id =T9.resourceId
    left join hostel_room_type T12 on T12.id =T5.roomTypeId
	left join users T13 on T13.id =T9.managerId
	left join users T14 on T14.id =T1.allotmentBy
    left join student_hostel_application T15 on T1.id=T15.allottedHostelRoomAllotmentId
    left join hostel_application_setup T16 on T16.id=T15.hostelApplicationSetupId
    left join academic_term T17 on T17.id=T16.year
left join internal_resources T18 on T11.id =T18.resourceId
    left join resource_academy_locations T19 on T19.id =T18.resourceAcademyLocationId
    left join academy_location T20 on T20.id=T19.academyLocationId
    where T1.id in (namedParams) and T1.allotmentStatus='ALLOTTED'" , 
    `jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_NUMBER",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "resourceName",
            "resultKey": "BUILDING_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "floorNumber",
            "resultKey": "FLOOR_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "roomNumber",
            "resultKey": "ROOM_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "bedNumber",
            "resultKey": "BED_NUMBER",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "resourceName",
            "resultKey": "SU_HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "roomType",
            "resultKey": "ROOM_TYPE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "allotmentDate",
            "resultKey": "ALLOTMENT_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 14,
            "value": "expectedCheckOutDate",
            "resultKey": "AVAILABLE_FROM,",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 15,
            "value": "printName",
            "resultKey": "MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 16,
            "value": "printName",
            "resultKey": "ALLOTMENT_BY",
            "displayCode": "",
            "displayOrder": 11
        },
{
            "id": 17,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },
{
            "id": 18,
            "value": "locationName",
            "resultKey": "CAMPUS",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}'
 WHERE  dataProviderId =@residenceRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_ALLOTMENT_CANCELLATION_RCPNT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='STUDENT_HOSTEL_ALLOTMENT_CANCELLATION_RCPNT');
 UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T3.code as STUDENT_ID,
    T3.firstName as STUDENT_FIRST_NAME,
	T3.firstName as FIRST_NAME,
	T3.printName as PRINT_NAME,
    T3.middleName AS STUDENT_MIDDLE_NAME,
    T3.lastName AS STUDENT_LAST_NAME,
    T3.printName AS STUDENT_PRINT_NAME,
    T4.emailId as EMAIL_ID,
    T4.mobileCountryCode as MOBILE_CODE,
    T4.mobileNumber as MOBILE_NO,
    T10.resourceName as BUILDING_NAME,
    T11.resourceName as SU_HOSTEL_NAME,
    T11.code as HOSTEL_CODE,
    T12.roomType as ROOM_TYPE,
    T1.cancelDate as CANCEL_DATE,
    T13.printName as MANAGER_NAME,
    T15.printName as RESIDENCE_ADMIN,
    T14.printName as CANCELLATION_BY,
    T16.itemValue as CANCELLATION_REASON,
   T19.itemValue as ACADEMIC_TERM,
    T22.locationName as CAMPUS
FROM
    hostel_room_allotment T1
    left join students T2 on T2.userId =T1.studentId
    left join users T3 on T3.id =T2.userId
    left join persons T4 on T4.id =T2.personId
    left join hostel_room T5 on T5.id =T1.roomId
    left join hostel_floor T6 on T6.id =T5.floorId
    left join hostel_bed T7 on T7.id =T5.id
    left join hostel_building T8 on T8.id =T6.buildinglId
    left join hostel T9 on T9.id =T8.hostelId
    left join resources T10 on T10.id =T8.resourceId
    left join resources T11 on T11.id =T9.resourceId
    left join hostel_room_type T12 on T12.id =T5.roomTypeId
	left join users T13 on T13.id =T9.managerId
	left join users T14 on T14.id =T1.cancellationBy
    left join users T15 on T15.id=T9.wardenId
    left join hostel_cancellation_reason T16 on T16.id=T1.cancelReasonId
 left join student_hostel_application T17 on T1.id=T17.allottedHostelRoomAllotmentId
    left join hostel_application_setup T18 on T18.id=T17.hostelApplicationSetupId
    left join academic_term T19 on T19.id=T18.year
    left join internal_resources T20 on T11.id =T20.resourceId
    left join resource_academy_locations T21 on T21.id =T20.resourceAcademyLocationId
    left join academy_location T22 on T22.id=T21.academyLocationId
    where T1.id in (namedParams) and T1.allotmentStatus='CANCELLED'" , 
    `jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "resourceName",
            "resultKey": "SU_HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "resourceName",
            "resultKey": "BUILDING_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "roomType",
            "resultKey": "ROOM_TYPE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "printName",
            "resultKey": "RESIDENCE_ADMIN",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "cancelDate",
            "resultKey": "CANCEL_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "itemValue",
            "resultKey": "CANCELLATION_REASON",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "CANCELLATION_BY",
            "displayCode": "",
            "displayOrder": 13
        },
{
            "id": 15,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 14
        },
{
            "id": 16,
            "value": "locationName",
            "resultKey": "CAMPUS",
            "displayCode": "",
            "displayOrder": 15
        }
    ]
}'
 WHERE  dataProviderId =@residenceRCPNT;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240213125549__Update_Add_Campus_year_RESIDENCE_ALLOTMENT () $$
DROP PROCEDURE IF EXISTS V20240213125549__Update_Add_Campus_year_RESIDENCE_ALLOTMENT $$
DELIMITER ;