DELIMITER $$
DROP PROCEDURE IF EXISTS V20240220172551__Create_ExternalCoSupervisorCDataProvider $$
CREATE PROCEDURE V20240220172551__Create_ExternalCoSupervisorCDataProvider()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='EXTERNAL_CO-SUPERVISOR_C_INFO')) THEN 
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'External Co-Supervisor C', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='External Co-Supervisor C');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'EXTERNAL_CO-SUPERVISOR_C_INFO', '1',null, '1', '1', 
"SELECT T1.id AS id,
T4.firstName AS external_co_supervisor_c_first_name,
T4.middleName AS external_co_supervisor_c_middle_name,
T4.lastName AS external_co_supervisor_c_last_name,
T4.alternateEmailId AS external_co_supervisor_c_alternative_email_id,
T4.emailId AS external_co_supervisor_c_email_id,
T4.phoneNo AS external_co_supervisor_c_telephone_no,
T4.mobileNumber AS external_co_supervisor_c_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as external_co_supervisor_c_address,
T13.code AS external_co_supervisor_c_id,
T11.salutationName AS external_co_supervisor_c_title,
T12.itemValue AS external_co_supervisor_c_gender

from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join person_functionary_details T3 on T3.personId=T2.personId
left join functionary_type on functionary_type.id=T3.functionaryTypeId 
left join staffs T5 on T5.userId=T3.functionaryUserId and functionary_type.itemCode='External Co-Supervisor C'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.functionaryUserId"
,
    'PRM_ADMISSION_ID', 'external_co_supervisor_c_first_name,external_co_supervisor_c_middle_name,external_co_supervisor_c_last_name,external_co_supervisor_c_address,external_co_supervisor_c_email_id,external_co_supervisor_c_alternative_email_id,external_co_supervisor_c_telephone_no,external_co_supervisor_c_mobile_no,external_co_supervisor_c_id,external_co_supervisor_c_title,external_co_supervisor_c_gender',
    "WHERE admission.id = PRM_ADMISSION_ID and functionary_type.itemCode='External Co-Supervisor C' order by T3.id  desc limit 1;",'0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('external_co_supervisor_c_first_name', 'External Co-Supervisor C First Name',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_middle_name', 'External Co-Supervisor C Middle Name',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_last_name', 'External Co-Supervisor C Last Name',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_address', 'External Co-Supervisor C Address',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_email_id', 'External Co-Supervisor C Email ID',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_alternative_email_id', 'External Co-Supervisor C Alternative Email ID',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_telephone_no', 'External Co-Supervisor C Telephone No.',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_mobile_no', 'External Co-Supervisor C Mobile No.',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_id', 'External Co-Supervisor C ID',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_title', 'External Co-Supervisor C Title',@dydtdatalinitemId+1),
    ('external_co_supervisor_c_gender', 'External Co-Supervisor C Gender',@dydtdatalinitemId+1);
    
END IF;

END $$
CALL V20240220172551__Create_ExternalCoSupervisorCDataProvider () $$ 
DROP PROCEDURE IF EXISTS V20240220172551__Create_ExternalCoSupervisorCDataProvider $$ 
DELIMITER ;