DELIMITER $$
DROP PROCEDURE IF EXISTS V20240327121634__Alter_PncDashboardDelayedCourseCBSView $$
CREATE PROCEDURE V20240327121634__Alter_PncDashboardDelayedCourseCBSView()
BEGIN

CREATE OR REPLACE
VIEW `pnc_dashboard_delayed_course_cbs` AS
    (SELECT 
        `ccp`.`academyLocationId` AS `academyLocationId`,
        `program`.`id` AS `programId`,
        `batch`.`id` AS `batchId`,
        `pbpc`.`id` AS `periodId`,
        `pbpc`.`academicTermId` AS `academicTermId`,
        `ccp`.`courseId` AS `courseId`,
        `ccp`.`sectionId` AS `sectionId`,
        CONCAT(`al`.`academyName`,
                ' - ',
                `al`.`locationName`) AS `AcademyLocation`,
        `program`.`programNameToBePrint` AS `ProgramName`,
        `batch`.`batchName` AS `BatchName`,
        `pbpc`.`programPeriodName` AS `PeriodName`,
        `c`.`courseName` AS `CourseName`,
        `cv`.`id` AS `CourseVariantId`,
        `cv`.`courseVariantCode` AS `CourseVariantCode`,
        `u`.`id` AS `facultyId`,
        `u`.`printName` AS `facultyName`,
        COUNT(0) AS `TotalSessions`,
        COUNT((CASE
            WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
        END)) AS `SessionTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND (`ccp`.`studentCourseAttendanceId` IS NOT NULL))
            THEN
                `ccp`.`id`
        END)) AS `SesssionConductedTillDate`,
        COUNT((CASE
            WHEN
                ((`ccp`.`sessionDate` <= SYSDATE())
                    AND (`ccp`.`studentCourseAttendanceId` IS NULL))
            THEN
                `ccp`.`id`
        END)) AS `DueTillDate`,
        ROUND(((COUNT((CASE
                    WHEN
                        ((`ccp`.`sessionDate` <= SYSDATE())
                            AND (`ccp`.`studentCourseAttendanceId` IS NULL))
                    THEN
                        `ccp`.`id`
                END)) / COUNT((CASE
                    WHEN (`ccp`.`sessionDate` <= SYSDATE()) THEN `ccp`.`id`
                END))) * 100),
                2) AS `Deviation`
    FROM
        ((((((((`course_coverage_plan` `ccp`
        LEFT JOIN `academy_location` `al` ON ((`ccp`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `courses` `c` ON ((`ccp`.`courseId` = `c`.`id`)))
        LEFT JOIN `course_variants` `cv` ON ((`ccp`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `users` `u` ON ((`ccp`.`facultyId` = `u`.`id`)))
        LEFT JOIN `program_batch_course_param` `pbcp` ON ((`cv`.`id` = `pbcp`.`courseVarientId`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbcp`.`progBatchPeriodConfigId` = `pbpc`.`id`)))
        LEFT JOIN `batches` `batch` ON ((`batch`.`id` = `pbpc`.`programBatchId`)))
        LEFT JOIN `programs` `program` ON ((`program`.`id` = `batch`.`programId`)))
    WHERE
        ((`c`.`assignSectionType` = 'CourseSection')
            AND (`ccp`.`whetherDeleted` = 0))
    GROUP BY `ccp`.`courseVariantId`);

END $$
CALL V20240327121634__Alter_PncDashboardDelayedCourseCBSView() $$
DROP PROCEDURE IF EXISTS V20240327121634__Alter_PncDashboardDelayedCourseCBSView $$
DELIMITER ;