DELIMITER $$
DROP PROCEDURE IF EXISTS V20240403103856__Create_StatementOfAccountAdhocEvent $$
CREATE PROCEDURE V20240403103856__Create_StatementOfAccountAdhocEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM `dtprovider` WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT')) THEN 
-- Ahdoc msg for Student


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_ACCOUNT_STATEMENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'STUDENT_ACCOUNT_STATEMENT');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.`id` AS ID,
	T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
	T1.`code` AS STUDENT_CODE,
	DATE_FORMAT(NOW(), '%d-%m-%Y') AS CURRENT_DATE_TODAY,
    T3.`emailId` AS EMAIL_ID,
       (CASE
        WHEN
            (SELECT 
                    emailHome
                FROM
                    fee_payer_detail
                WHERE
                    T2.personId = fee_payer_detail.personId
                        AND fee_payer_detail.isPrimaryFeePayer = 1
                LIMIT 1) IS NOT NULL
        THEN
            (SELECT 
                    emailHome
                FROM
                    fee_payer_detail
                WHERE
                    T2.personId = fee_payer_detail.personId
                        AND fee_payer_detail.isPrimaryFeePayer = 1
                LIMIT 1)
        ELSE (SELECT 
                emailWork
            FROM
                fee_payer_detail
            WHERE
                T2.personId = fee_payer_detail.personId
                    AND payerType = 'CORPORATE'
                    AND fee_payer_detail.isPrimaryFeePayer = 1
            LIMIT 1)
    END) AS 'ALTERNATE_EMAIL_ID',
	T3.`externalSysRefOne` AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1, 
	T7.`programNameToBePrint` AS PROGRAM,
    T7.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_OTHER_LANGUAGE,
    T6.`printName` AS BATCH,
    T8.`seatName` AS SEAT_TYPE,
    T8.`seatNameOtherLanguage` AS SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE,
	T3.`printNameOtherLanguage` AS STUDENT_PRINT_NAME_OTHER_LANGUAGE,
	T3.`firstNameOtherLanguage` AS STUDENT_FIRST_NAME_OTHER_LANGUAGE,
	T3.`middleNameOtherLanguage` AS STUDENT_MIDDLE_NAME_OTHER_LANGUAGE,
	T3.`lastNameOtherLanguage` AS STUDENT_LAST_NAME_OTHER_LANGUAGE
    FROM
	users T1
		LEFT JOIN
    students T2 ON T1.id = T2.userId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
	    LEFT JOIN
	admission T4 ON T2.userId = T4.studentId
        LEFT JOIN
    prog_batch_seat_config T5 ON T4.programBatchSeatConfigId = T5.id 
        LEFT JOIN
    batches T6 ON T6.id=T5.programBatchId
        LEFT JOIN
    programs T7 ON T7.id = T6.programId
	    LEFT JOIN
    seat_types T8 ON T5.seatTypeId = T8.id
WHERE
    T1.id IN (namedParams) and T4.activeStatus=true order by T4.id desc limit 1",'{
  "id": 1,
  "searchResultViewColumns": [
    {
      "id": 1,
      "value": "id",
      "resultKey": "ID",
      "displayCode": "",
      "displayOrder": 0
    },
    {
      "id": 2,
      "value": "printName",
      "resultKey": "PRINT_NAME",
      "displayCode": "",
      "displayOrder": 1
    },
    {
      "id": 3,
      "value": "firstName",
      "resultKey": "FIRST_NAME",
      "displayCode": "",
      "displayOrder": 2
    },
    {
      "id": 4,
      "value": "middleName",
      "resultKey": "MIDDLE_NAME",
      "displayCode": "",
      "displayOrder": 3
    },
    {
      "id": 5,
      "value": "lastName",
      "resultKey": "LAST_NAME",
      "displayCode": "",
      "displayOrder": 4
    },
    {
      "id": 6,
      "value": "code",
      "resultKey": "STUDENT_CODE",
      "displayCode": "",
      "displayOrder": 5
    },
    {
      "id": 7,
      "value": "Current Date",
      "resultKey": "CURRENT_DATE_TODAY",
      "displayCode": "",
      "displayOrder": 6
    },
    {
      "id": 8,
      "value": "externalSysRefOne",
      "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
      "displayCode": "",
      "displayOrder": 7
    },
    {
      "id": 9,
      "value": "programNameToBePrint",
      "resultKey": "PROGRAM",
      "displayCode": "",
      "displayOrder": 8
    },
    {
      "id": 10,
      "value": "programNameToBePrintLanguageOne",
      "resultKey": "PROGRAM_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 9
    },
    {
      "id": 11,
      "value": "printName",
      "resultKey": "BATCH",
      "displayCode": "",
      "displayOrder": 10
    },
    {
      "id": 12,
      "value": "seatName",
      "resultKey": "SEAT_TYPE",
      "displayCode": "",
      "displayOrder": 11
    },
    {
      "id": 13,
      "value": "seatNameOtherLanguage",
      "resultKey": "SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 12
    },
    {
      "id": 14,
      "value": "printNameOtherLanguage",
      "resultKey": "STUDENT_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 13
    },
    {
      "id": 15,
      "value": "firstNameOtherLanguage",
      "resultKey": "STUDENT_FIRST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 14
    },
    {
      "id": 16,
      "value": "middleNameOtherLanguage",
      "resultKey": "STUDENT_MIDDLE_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 15
    },
    {
      "id": 17,
      "value": "lastNameOtherLanguage",
      "resultKey": "STUDENT_LAST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 16
    }
  ]
}');

-- set predefine msg template for statement of account
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='STUDENT_ACCOUNT_STATEMENT');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`,`templatelanguageValue`) 
VALUES (@msgTemplateConfigId+1,'Email Account Statement',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Email Account Statement',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1,'English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','','');
END IF; 


IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_PRINT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_PRINT_NAME', 'Student Print Name', 'Student Print Name', 'Student Druk Naam', 'Tên in hoa của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_FIRST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_FIRST_NAME', 'Student First Name', 'Student First Name', 'Student Voornaam', 'Tên học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_MIDDLE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_MIDDLE_NAME', 'Student Middle Name', 'Student Middle Name', 'Student se middelnaam', 'Tên đệm của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_LAST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_LAST_NAME', 'Student Last Name', 'Student Last Name', 'Student Van Naam', 'Họ của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CURRENT_DATE_TODAY')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CURRENT_DATE_TODAY', 'Current Date Today', 'Current Date Today', 'Huidige Datum Vandag', 'Ngày hiện tại Hôm nay',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_EXTERNAL_REFERENCE_NUMBER_1')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_EXTERNAL_REFERENCE_NUMBER_1', 'Student External Reference Number 1', 'Student External Reference Number 1', 'Student Eksterne Verwysingsnommer 1', 'Số tham chiếu bên ngoài của sinh viên 1',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_PRINT_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_PRINT_NAME_OTHER_LANGUAGE', 'Student Print Name other language', 'Student Print Name other language', 'Student Druk Noem ander taal', 'Tên viết in của học sinh ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_FIRST_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_FIRST_NAME_OTHER_LANGUAGE', 'Student First Name other language', 'Student First Name other language', 'Student Voornaam ander taal', 'Tên học sinh Ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_MIDDLE_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_MIDDLE_NAME_OTHER_LANGUAGE', 'Student Middle Name other language', 'Student Middle Name other language', 'Student Middelnaam ander taal', 'Tên đệm của học sinh Ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_LAST_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_LAST_NAME_OTHER_LANGUAGE', 'Student Last Name other language', 'Student Last Name other language', 'Student Van Naam ander taal', 'Họ của học sinh Ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROGRAM_PRINT_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROGRAM_PRINT_NAME_OTHER_LANGUAGE', 'Program Print Name other language', 'Program Print Name other language', 'Program Druk Noem ander taal', 'Chương trình Tên in ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE', 'Seat Type Print Name other language', 'Seat Type Print Name other language', 'Sitplek Tipe Druk Naam ander taal', 'Loại ghế In Tên ngôn ngữ khác',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_ACCOUNT_STATEMENT')) THEN 
INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,russLanguage,frenLanguage,afriLanguage,vietLanguage,spanLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS','STUDENT_ACCOUNT_STATEMENT','Student Account Statement','Student Account Statement',NULL,NULL,'Studenterekeningstaat','Sao kê tài khoản sinh viên',NULL,now(),1);
END IF;
END $$
CALL V20240403103856__Create_StatementOfAccountAdhocEvent () $$ 
DROP PROCEDURE IF EXISTS V20240403103856__Create_StatementOfAccountAdhocEvent $$ 
DELIMITER ;