DELIMITER $$
DROP PROCEDURE IF EXISTS V20240408190040__Create_ManageAssessmentStatus $$
CREATE PROCEDURE V20240408190040__Create_ManageAssessmentStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_assessment_status')) THEN 
CREATE TABLE `manage_assessment_status` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `evaluationPlanId` BIGINT NOT NULL,
  `programId` BIGINT DEFAULT NULL,
  `batchId` BIGINT DEFAULT NULL,
  `periodId` BIGINT DEFAULT NULL ,
  `typeId` BIGINT DEFAULT NULL,
  `subTypeId` BIGINT DEFAULT NULL,
  `methodId` BIGINT DEFAULT NULL,
  `courseIds` VARCHAR(900) DEFAULT NULL,
  `eventStatus` VARCHAR(255) DEFAULT NULL,
  `status` VARCHAR(255) DEFAULT NULL,
  `eventStatusCalculation` BOOLEAN default FALSE,
  `whetherDynamicEvent` BOOLEAN default TRUE,
   `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
   CONSTRAINT `fk_manage_assessment_status_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
  );
END IF; 

END $$
CALL V20240408190040__Create_ManageAssessmentStatus () $$ 
DROP PROCEDURE IF EXISTS V20240408190040__Create_ManageAssessmentStatus $$ 
DELIMITER ;