DELIMITER $$
DROP PROCEDURE IF EXISTS V20240520150335__Insert_OUM_Invoice_Report_Mapping $$
CREATE PROCEDURE V20240520150335__Insert_OUM_Invoice_Report_Mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_CODE' AND templateName='OUM Invoice Template - Core ERP')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('3', 'MANAGE_BILLS_CODE', 'OUM Invoice Template - Core ERP', 'Bill.png', 'CommonReportOUM Invoice Template - Core ERP.jasper', 'All', b'0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'OUM Invoice Template - Core ERP.jasper', 'AcademiaLogo.png');

set @reportTempId= (select max(id) from report_template where   templateName='OUM Invoice Template - Core ERP');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_INVOICE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId , 'TRANS_INVOICE', 'Invoice', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_LERNER_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_LERNER_ID', 'Lerner ID.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_LERNER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_LERNER_NAME', 'Lerner Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_PERIOD', 'Period', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_PROGRAMME_&_INTAKE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_PROGRAMME_&_INTAKE', 'Programme & Intake', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_MOBILE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_MOBILE_NO', 'Mobile No.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_EMAIL_ADDRESS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_EMAIL_ADDRESS', 'Email Address', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_DATE', 'Date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_INVOICE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_INVOICE_NO', 'Invoice No.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_FEE_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_FEE_HEAD', 'Fee Head', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_AMOUNT', 'Amount', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_TOTAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_TOTAL', 'Total', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_MODE_OF_PAYMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_MODE_OF_PAYMENT', 'Mode of Payments', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_POINT_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_POINT_ONE','Payments are not being accepted at OU cash counter.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_POINT_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_POINT_TWO', 'Please effect payment Online on the OU Portal at the "Online Payment" section.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @reportTempId and keyValue='TRANS_POINT_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId, 'TRANS_POINT_THREE', 'This is computer-generated document and requires no authentication. If you have any queries, contact us by email at Feesfinance@open.ac.mu', '1', NOW());
END IF;

END IF;
END $$
CALL V20240520150335__Insert_OUM_Invoice_Report_Mapping() $$
DROP PROCEDURE IF EXISTS V20240520150335__Insert_OUM_Invoice_Report_Mapping $$
DELIMITER ;