DELIMITER $$
DROP PROCEDURE IF EXISTS getStudentDetailForMoodleGrade $$
CREATE PROCEDURE getStudentDetailForMoodleGrade(IN academyLocationId INTEGER)
BEGIN
select mt.moodleId as studentMoodleid, mc.moodleCourseId courseVarMoodleid, c.courseGradeType, er.* from examination_result er
join moodle_course mc on er.courseVariantId = mc.academiaCourseVariantId and mc.hierarchy='CAT_GROUP_PROGRAM_ACADEMICTERM_COURSE_VARIANT'
join admission a on er.admissionId = a.id and a.activeStatus=true and mc.academyLocationId = a.academyLocationId
join moodle_transaction_info mt on a.studentId = mt.academiaId and mt.moodleTransactionType = 'STUDENT' 
join course_variants cv on er.courseVariantId = cv.id
join courses c on cv.courseId = c.id and c.courseMarksGrades='G'
join evaluation_type_course etc on er.courseVariantId = etc.courseVariantId and er.sectionId = etc.sectionId and er.periodId = etc.periodId
join course_variant_event_mapping cvem on cvem.evaluationTypeCourseId = etc.id and cvem.eventStatus='CONDUCTED'
where (er.finalGrade is null or lower(er.finalGrade)='referral' ) and a.academyLocationId=academyLocationId;
END$$
DELIMITER ;