DELIMITER $$
DROP PROCEDURE IF EXISTS V20240611153219__Insert_JIT_Receipt_Settlement $$
CREATE PROCEDURE V20240611153219__Insert_JIT_Receipt_Settlement()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt With Settlement' );

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_SETTLEMENT_CODE' and `templateName`='JIT Receipt with Settlement')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'JIT Receipt with Settlement', 'RECEIPT_WITH_SETTLEMENT_CODE_JIT.png', 'JIT_CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RECEIPT_WITH_SETTLEMENT_CODE_JIT.jasper', 'AcademiaLogo.jpg');
END IF;

set @rID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_RECEIPTNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_RECEIPTNO', 'Receipt No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BATCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BATCH', 'Batch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_NAME', 'Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_FATHER_NAME', 'Father Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_COURSE', 'Course', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_STUDENT_ID', 'Student Id', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ADMISSION_MODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ADMISSION_MODE', 'Admission Mode', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ACADEMIC_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ACADEMIC_YEAR', 'Academic Year/Sem', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_SR_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_SR_NO', 'S.No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_ACCOUNT_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_ACCOUNT_HEAD', 'Account Head', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_AMOUNT', 'Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_DUE_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_DUE_AMOUNT', 'Total Due Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL_IN_WORDS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL_IN_WORDS', 'Total In Words', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_TOTAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_TOTAL', 'Total', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_CURRENCY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_CURRENCY', 'Currency', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_INSTRUMENT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_INSTRUMENT_NO', 'Instrument Number', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_INSTRUMENT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_INSTRUMENT_DATE', 'Instrument Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_REMARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_REMARKS', 'Remarks', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_BANK_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_BANK_NAME', 'Instrument Bank Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_POINT_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_POINT_ONE', 'Students who are desirous to receive any freeship/Scholarship under any category should fill the required application forms and duly submit the same to the competent authority as per their specified procedure within the prescribed due date.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rID and keyValue='TRANS_POINT_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rID, 'TRANS_POINT_TWO', 'Failing which they are liable to pay the prescribed fees of the institute.', '1', now());
END IF;


END $$
CALL V20240611153219__Insert_JIT_Receipt_Settlement() $$
DROP PROCEDURE IF EXISTS V20240611153219__Insert_JIT_Receipt_Settlement $$
DELIMITER ;