DELIMITER $$
DROP PROCEDURE IF EXISTS V20240617161541__Create_SendEmailAccStatementTable $$
CREATE PROCEDURE V20240617161541__Create_SendEmailAccStatementTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='send_email_account_statement')) THEN 
CREATE TABLE `send_email_account_statement`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`studentId` BIGINT(20) NOT NULL,
	`statementFrom` DATE NULL,
	`statementTo` DATE NULL,
	`statementEmailTabFilterId` BIGINT(20) NOT NULL,
	`addressType` VARCHAR(10) NULL,
	`documentPath` VARCHAR(255) NULL,
	`status` VARCHAR(10) NOT NULL,
	`failureReason` VARCHAR(255) NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`), 
	CONSTRAINT `send_email_account_statement_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `users`(`id`),
	CONSTRAINT `send_email_account_statement_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB;
END IF; 

END $$
CALL V20240617161541__Create_SendEmailAccStatementTable () $$ 
DROP PROCEDURE IF EXISTS V20240617161541__Create_SendEmailAccStatementTable $$ 
DELIMITER ;