DELIMITER $$
DROP PROCEDURE IF EXISTS V20240618102225__Create_ceremony $$
CREATE PROCEDURE V20240618102225__Create_ceremony()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='ceremony')) THEN 
CREATE TABLE `ceremony` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `ceremonyId` VARCHAR(255) NOT NULL UNIQUE,
  `ceremonyName` VARCHAR(255) DEFAULT NULL,
  `ceremonyNameOtherLanguage` VARCHAR(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `fromTime` time DEFAULT NULL,
  `tillTime` time DEFAULT NULL,
  `venue` TEXT DEFAULT NULL,
  `description` TEXT DEFAULT NULL,
  `createdBy` BIGINT DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`), 
  INDEX `fk_ceremony_createdBy_idx` (`createdBy`),
  CONSTRAINT `fk_ceremony_createdBy_idx`
    FOREIGN KEY (`createdBy`)
    REFERENCES `users` (`id`),
    CONSTRAINT `fk_ceremony_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20240618102225__Create_ceremony () $$ 
DROP PROCEDURE IF EXISTS V20240618102225__Create_ceremony $$ 
DELIMITER ;