DELIMITER $$
DROP PROCEDURE IF EXISTS V20240618172157__Insert_UserUsageEmailInternalCsm $$
CREATE PROCEDURE V20240618172157__Insert_UserUsageEmailInternalCsm()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='user_usage_email_internal')) THEN 
CREATE TABLE `user_usage_email_internal` (
	`id` BIGINT NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
    UNIQUE KEY itemValue_UNIQUE (itemValue),
    KEY fk_user_usage_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_user_usage_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
) ENGINE=InnoDB;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'user_usage_email_internal')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'user_usage_email_internal','USER_USAGE_EMAIL_INTERNAL','General Setup','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((select * from standard_master where tableName = 'user_usage_email_internal')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'user_usage_email_internal');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'USER_USAGE_EMAIL_INTERNAL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'USER_USAGE_EMAIL_INTERNAL', 'User Usage Email Internal', 'User Usage Email Internal','
Gebruikersgebruik-e-pos intern','Người dùng sử dụng Email nội bộ',now(),1);

END IF;


END $$
CALL V20240618172157__Insert_UserUsageEmailInternalCsm() $$
DROP PROCEDURE IF EXISTS V20240618172157__Insert_UserUsageEmailInternalCsm $$
DELIMITER ;