DELIMITER $$
DROP PROCEDURE IF EXISTS V20240621150022__Insert_StudTranTranslations $$
CREATE PROCEDURE V20240621150022__Insert_StudTranTranslations()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'SERVICEREQUEST' and keyName = 'ACADEMIC_TERM')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('SERVICEREQUEST', 'ACADEMIC_TERM', 'Academic Term', 'Academic Term','Akademiese kwartaal','Học thuật',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'SERVICEREQUEST' and keyName = 'FROM_ACADEMY_LOCATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('SERVICEREQUEST', 'FROM_ACADEMY_LOCATION', 'From Academy Location', 'From Academy Location','Van Akademie Lokasie','Từ địa điểm học viện',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'SERVICEREQUEST' and keyName = 'FROM_PERIOD')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('SERVICEREQUEST', 'FROM_PERIOD', 'From Period', 'From Period','Van Periode','Từ thời kỳ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'SERVICEREQUEST' and keyName = 'FROM_BATCH')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('SERVICEREQUEST', 'FROM_BATCH', 'From Batch', 'From Batch','Van Batch','Từ lô',now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='academicTermId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','academicTerm','academicTermId','customcombobox',0,0,NULL,1,now(),'Academic Term','','Student Transfer','Create','Academic Term',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='fromAcademicLocationId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','fromAcademicLocation','fromAcademicLocationId','customcombobox',0,0,NULL,1,now(),'Academy Location','','Student Transfer','Create','Academy Location',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='fromBatchId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','fromBatch','fromBatchId','customcombobox',0,0,NULL,1,now(),'From Batch','','Student Transfer','Create','From Batch',0);
END IF;


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='fromPeriodId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','fromPeriod','fromPeriodId','customcombobox',0,0,NULL,1,now(),'From Period','','Student Transfer','Create','From Period',0);
END IF;

SET SQL_SAFE_UPDATES =0;
UPDATE  form_field_info SET formScreenName='Student Transfer' WHERE formAliasName='studenttransferrequestdetailspanel' and formScreenName='Exchange Semester';
SET SQL_SAFE_UPDATES =1;

END $$
CALL V20240621150022__Insert_StudTranTranslations() $$
DROP PROCEDURE IF EXISTS V20240621150022__Insert_StudTranTranslations $$
DELIMITER ;