DELIMITER $$
DROP PROCEDURE IF EXISTS V20240624162052__Create_canvasUserCouSecMapping $$
CREATE PROCEDURE V20240624162052__Create_canvasUserCouSecMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='canvas_user_course_section_mapping')) THEN 
CREATE TABLE canvas_user_course_section_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    membershipId bigint NOT NULL,
    canvasUserId bigint NOT NULL,
    academiaUserId bigint NOT NULL,
	canvasCourseSectionId bigint NOT NULL,
	academiaCourseVariantId bigint NOT NULL,
    courseSectionRoleId VARCHAR(255),
	academyLocationId bigint NOT NULL,
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_canvas_user_course_membership_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_canvas_user_course_membership_academiaCourseVariantId_idx (academiaCourseVariantId),
  KEY fk_canvas_user_course_membership_academiaUserId_idx (academiaUserId),
  KEY fk_canvas_course_section_membership_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_canvas_user_course_membership_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_canvasuser_course_membership_academiaCourseVariantId FOREIGN KEY (academiaCourseVariantId) REFERENCES course_variants (id),
  CONSTRAINT fk_canvas_user_course_membership_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id),
  CONSTRAINT fk_canvas_course_membership_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240624162052__Create_canvasUserCouSecMapping () $$ 
DROP PROCEDURE IF EXISTS V20240624162052__Create_canvasUserCouSecMapping $$ 
DELIMITER ;