DELIMITER $$
DROP PROCEDURE IF EXISTS canvasDeenrollment $$
CREATE PROCEDURE canvasDeenrollment()
BEGIN
  select map.id as id , 'Student' as courseSectionRoleId,
	map.canvasCourseSectionId as canvasCourseSectionId, map.canvasUserId as canvasUserId,
	map.membershipId as membershipId,
	canvasCourse.canvasCourseId as canvasCourseId,
	map.academyLocationId as locationId
from canvas_user_course_section_mapping map 
join canvas_course_section_mapping as canvasSection on canvasSection.canvasCourseSectionId=map.canvasCourseSectionId and map.academyLocationId=canvasSection.academyLocationId
join canvas_course_mapping as canvasCourse on canvasCourse.id=canvasSection.canvasCourseMappingId and canvasSection.academyLocationId=canvasCourse.academyLocationId
join users u on map.academiaUserId = u.id and map.courseSectionRoleId='Student'
join admission a on a.studentId = u.id and map.academyLocationId=a.academyLocationId and a.activeStatus=true
join student_course_enrollment enrol on  enrol.courseVarientId=map.academiaCourseVariantId 
and enrol.admissionId = a.id and enrol.exitDate is not null
union all
select map.id as id , 'Student' as courseSectionRoleId,
	map.canvasCourseSectionId as canvasCourseSectionId, map.canvasUserId as canvasUserId,
	map.membershipId as membershipId,
	canvasCourse.canvasCourseId as canvasCourseId,
	map.academyLocationId as locationId 
from canvas_user_course_section_mapping map
join canvas_course_section_mapping as canvasSection on canvasSection.canvasCourseSectionId=map.canvasCourseSectionId and map.academyLocationId=canvasSection.academyLocationId
join canvas_course_mapping as canvasCourse on canvasCourse.id=canvasSection.canvasCourseMappingId and canvasSection.academyLocationId=canvasCourse.academyLocationId
join  users u on map.academiaUserId = u.id and map.courseSectionRoleId='Student'
join admission a on a.studentId = u.id  and map.academyLocationId=a.academyLocationId and a.activeStatus=true
left join student_course_enrollment enrol on  enrol.courseVarientId=map.academiaCourseVariantId and enrol.admissionId = a.id
where enrol.id is null
union all 
select map.id as id , 'Instructor' as courseSectionRoleId,
	map.canvasCourseSectionId as canvasCourseSectionId, map.canvasUserId as canvasUserId,
	map.membershipId as membershipId,
	canvasCourse.canvasCourseId as canvasCourseId,
	map.academyLocationId as locationId
FROM canvas_user_course_section_mapping map
join canvas_course_section_mapping as canvasSection on canvasSection.canvasCourseSectionId=map.canvasCourseSectionId and map.academyLocationId=canvasSection.academyLocationId
join canvas_course_mapping as canvasCourse on canvasCourse.id=canvasSection.canvasCourseMappingId and canvasSection.academyLocationId=canvasCourse.academyLocationId
left JOIN (
    SELECT t2.*
    FROM program_batch_course_param t2
    INNER JOIN prog_batch_course_faculty t3 ON t2.id = t3.progBatchCourseParamId
) filtered_t2 ON map.academiaCourseVariantId = filtered_t2.courseVarientId
LEFT JOIN prog_batch_course_faculty t3 ON filtered_t2.id = t3.progBatchCourseParamId AND t3.facultyId = map.academiaUserId
WHERE t3.facultyId IS NULL
AND map.courseSectionRoleId = 'Instructor';
 
END $$ 
DELIMITER ;