DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseFcMappingCanvasST $$
CREATE PROCEDURE fatchCourseFcMappingCanvasST()
BEGIN
 SELECT 
    FUNC_INC_VAR_SESSION_REC() AS `id`,
    cum.canvasUserId AS 'canvasUserId',
    pbcf.facultyId AS 'facultyId',
    ccsm.canvasCourseSectionId AS 'canvasCourseSectionId',
    cv.id AS 'courseVariantsId',
    1 AS 'locationId'
FROM
    program_batch_course_param pbcp
        JOIN
    prog_batch_course_faculty pbcf ON pbcp.id = pbcf.progBatchCourseParamId
        JOIN
    course_variants cv ON cv.id = pbcp.courseVarientId
        JOIN
    courses c ON c.id = cv.courseId
        JOIN
    canvas_course_section_mapping ccsm ON ccsm.academiaCourseVariantId = cv.id
        JOIN
    canvas_user_mapping cum ON cum.academiaUserId = pbcf.facultyId
        LEFT JOIN
    canvas_user_course_section_mapping cucsm ON cucsm.academiaCourseVariantId = cv.id
        AND cucsm.academiaUserId = pbcf.facultyId
WHERE
    cucsm.id IS NULL
    group by
    pbcf.facultyId,
    cv.id;
END $$ 
DELIMITER ;