DELIMITER $$
DROP PROCEDURE IF EXISTS getEvaluationLevelOneAvg $$
CREATE PROCEDURE getEvaluationLevelOneAvg(
    IN evaluationPlanLevelOneId INT,
    IN courseVariantId INT
)
BEGIN
  SELECT
    CASE
        WHEN levelOne.marksOrGrade = 'MARK' THEN
            (SELECT
                ROUND(AVG(onerank.effectiveMarks)) AS avgMarksGrade
             FROM
                evaluation_plan_level_one_rank AS onerank
             WHERE
                onerank.evaluationPlanLevelOneId = levelOne.id
                AND onerank.courseVariantId = courseVariantId)
        WHEN levelOne.marksOrGrade = 'GRADE' THEN
            (SELECT
                g.gradeName as avgMarksGrade
             FROM
                grade AS g
             JOIN
                (SELECT
                    ROUND(AVG(onerank.gradePoint)) AS average_gradePoint,
                    levelOne.gradeType
                 FROM
                    evaluation_plan_level_one_rank AS onerank
                 JOIN
                    evaluation_plan_level_one AS levelOne ON levelOne.id = onerank.evaluationPlanLevelOneId
                 WHERE
                    onerank.evaluationPlanLevelOneId = levelOne.id
                    AND onerank.courseVariantId = courseVariantId
                 GROUP BY
                    levelOne.gradeType) AS avgGrades
             ON
                g.gradeType = avgGrades.gradeType
                AND g.gradePoint = avgGrades.average_gradePoint)
        ELSE
            NULL
    END AS result
FROM
    evaluation_plan_level_one AS levelOne
WHERE
    levelOne.id = evaluationPlanLevelOneId;
END$$

DELIMITER ;