DELIMITER $$
DROP PROCEDURE IF EXISTS V20240806123810__Insert_KCU_STAFF_ID_CARD $$
CREATE PROCEDURE V20240806123810__Insert_KCU_STAFF_ID_CARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KCU_STAFF_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'KCU_STAFF_ID_CARD', 'KCU Staff ID Card', 'id_card_front.png', 'CommonReport_KCU_STAFF_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'KCU Staff ID Card.jasper', 'AcademiaLogo.png');
END IF; 

set @KCU_STAFF_ID_CARD = (select max(id) from report_template where templateCode ='KCU_STAFF_ID_CARD');

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_DEPARTMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_DEPARTMENT', 'Department:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ISSUED_ON')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ISSUED_ON', 'Issued on:', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_EXPIRY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_EXPIRY', 'Expiry:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ID_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ID_NO', 'ID No:', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_HOLDERS_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_HOLDERS_SIGNATURE', 'Holder’s Signature', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_AUTHORIZED_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_AUTHORIZED_SIGNATURE', 'Authorized Signature', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_ISSUING_OFFICER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_ISSUING_OFFICER', 'Issuing Officer:', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE  reportTemplateId=@KCU_STAFF_ID_CARD and keyValue='TRANS_IF_FOUND')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KCU_STAFF_ID_CARD, 'TRANS_IF_FOUND', 'If found please return to the above address or the nearest police station', '1', NOW());
END IF;


END $$
CALL V20240806123810__Insert_KCU_STAFF_ID_CARD() $$
DROP PROCEDURE IF EXISTS V20240806123810__Insert_KCU_STAFF_ID_CARD $$
DELIMITER ;