DELIMITER $$
DROP PROCEDURE IF EXISTS V20240807170213__Alter_governmentSponsorIdPerson $$
CREATE PROCEDURE V20240807170213__Alter_governmentSponsorIdPerson()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='governmentSponsorId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `governmentSponsorId` BIGINT NULL;
END IF;

IF EXISTS ((SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='persons_fk_governmentSponsorId' and table_name='persons')) THEN 
ALTER TABLE `persons` 
DROP FOREIGN KEY `persons_fk_governmentSponsorId`;
END IF;

IF EXISTS ((SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='persons_new_fk_governmentSponsorId' and table_name='persons')) THEN 
ALTER TABLE `persons` 
DROP FOREIGN KEY `persons_new_fk_governmentSponsorId`;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='persons_fk_governmentSponsorId') THEN
ALTER TABLE `persons` 
ADD CONSTRAINT `persons_fk_governmentSponsorId`
FOREIGN KEY (`governmentSponsorId`)
REFERENCES `government_sponsor_csm` (`id`);
END IF; 


END $$
CALL V20240807170213__Alter_governmentSponsorIdPerson() $$
DROP PROCEDURE IF EXISTS V20240807170213__Alter_governmentSponsorIdPerson $$
DELIMITER ;