DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808175156__Create_passout_rule_period_details $$
CREATE PROCEDURE V20240808175156__Create_passout_rule_period_details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='passout_rule_period_details')) THEN 
CREATE TABLE `passout_rule_period_details`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`passoutRuleDetailsId` BIGINT(20) NOT NULL,
    `periodId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `passout_rule_period_idx1` (`passoutRuleDetailsId` ASC),
	INDEX `passout_rule_period_idx2` (`periodId` ASC),
	INDEX `passout_rule_period_idx3` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_passout_rule_period_1` FOREIGN KEY (`passoutRuleDetailsId`) REFERENCES `passout_rule_details`(`id`),
    CONSTRAINT `fk_passout_rule_period_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`),
	CONSTRAINT `fk_passout_rule_period_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240808175156__Create_passout_rule_period_details () $$ 
DROP PROCEDURE IF EXISTS V20240808175156__Create_passout_rule_period_details $$ 
DELIMITER ;