DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808190727__Create_CreatePromotionCriteriaRules $$
CREATE PROCEDURE V20240808190727__Create_CreatePromotionCriteriaRules()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='promotion_criteria_rules')) THEN 
CREATE TABLE `promotion_criteria_rules`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
    	`progBatchPeriodPromotionCriteriaDetailsId` BIGINT(20) NOT NULL,
    	`numberOfCourses` INT NULL DEFAULT NULL,
	`totalCredits`FLOAT(10,2) NULL DEFAULT NULL,
	`minimumCredits`FLOAT(10,2) NULL DEFAULT NULL,
	`progressionStatusId` BIGINT(20) NULL DEFAULT NULL,
    	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    	FOREIGN KEY (`progBatchPeriodPromotionCriteriaDetailsId`) REFERENCES `prog_batch_period_promotion_criteria_details`(`id`),
	FOREIGN KEY (`progressionStatusId`) REFERENCES `progression_status`(`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240808190727__Create_CreatePromotionCriteriaRules () $$ 
DROP PROCEDURE IF EXISTS V20240808190727__Create_CreatePromotionCriteriaRules $$ 
DELIMITER ;