DELIMITER $$
DROP PROCEDURE IF EXISTS V20240812172658__Update_Rcpnt_Type_Student_fp_dtp $$
CREATE PROCEDURE V20240812172658__Update_Rcpnt_Type_Student_fp_dtp()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='RCPNT_TYPE_STUDENT_FP_DTP')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='RCPNT_TYPE_STUDENT_FP_DTP' limit 1);
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T2.id AS ID,
        T4.`salutationName` AS SALUTATION_NAME,
        T2.`firstName` AS FIRST_NAME,
        T2.`middleName` AS MIDDLE_NAME,
        T2.`lastName` AS LAST_NAME,
        T3.`emailId` AS EMAIL_ID,
        T3.`mobileNumber` AS MOBILE_NO,
        T3.`mobileCountryCode` AS MOBILE_CODE,
        ml.code AS LANGUAGE_KEY,
        T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
        T2.resetPassword AS PDF_PASSWORD,
        T6.displayName AS ACADEMY_NAME_LOCATION,
        T6.academyName AS ACADEMY_NAME,
    T8.primaryeEmailId AS ACADEMY_EMAIL,
         T8.websiteURL AS WEBSITE_URL,
         concat(T8.phoneCountryCode,\'-\',T8.phoneAreaCode,\'-\',T8.phoneNo) AS PHONE_NUMBER,
        (CASE
            WHEN
                T6.logoUrl IS NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl,
                        \'/\',
                        \'emailer/images/logo_default_image.png\')
            WHEN
                T6.logoUrl IS NULL
                    AND org.orgUrl IS NULL
            THEN
                \'https://www.serosoft.com/mailer/academiaerp_logo_red.png\'
            ELSE CONCAT(org.orgUrl, \'/\', T6.logoUrl)
        END) AS LOGO_URL,
        (CASE
            WHEN
                T6.headerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T6.headerUrl)
            ELSE NULL
        END) AS HEADER_URL,
        (CASE
            WHEN
                T6.footerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T6.footerUrl)
            ELSE NULL
        END) AS FOOTER_URL
    FROM
        `students` T1
            INNER JOIN
        `users` T2 ON T2.`id` = T1.`userId`
            INNER JOIN
        `persons` T3 ON T3.`id` = T1.`personId`
            LEFT JOIN
        `salutations` T4 ON T4.`id` = T3.`salutationId`
            LEFT JOIN
        multi_language ml ON ml.id = T3.correspondence_language
            LEFT JOIN
        admission T5 ON T5.studentId = T2.id
            LEFT JOIN
        academy_location T6 ON T6.id = T5.academyLocationId
            LEFT JOIN
        academy_location_addresses T7 ON T7.academyLocationId = T6.id
            LEFT JOIN
        address T8 ON T8.id = T7.addressId AND T8.addressTypeId = 10
            LEFT JOIN
        organizations org ON org.id = 1
    WHERE
        T2.id IN (namedParams)
    ORDER BY T5.admissionDate DESC
    LIMIT 1'
WHERE
    dataProviderId=@residenceRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240812172658__Update_Rcpnt_Type_Student_fp_dtp () $$
DROP PROCEDURE IF EXISTS V20240812172658__Update_Rcpnt_Type_Student_fp_dtp $$
DELIMITER ;