DELIMITER $$
DROP PROCEDURE IF EXISTS V20240813151442__Create_import_marks_remarks_filter $$
CREATE PROCEDURE V20240813151442__Create_import_marks_remarks_filter()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='import_marks_remarks_filter')) THEN 
CREATE TABLE `import_marks_remarks_filter`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`jobId` BIGINT(20) NOT NULL,
	`assessmentSchemeType` VARCHAR(50) NOT NULL,
	`academicTermId` BIGINT(20) NULL DEFAULT NULL,
	`courseId` BIGINT(20) NULL DEFAULT NULL,
	`courseVariantId` BIGINT(20) NOT NULL,
	`assessmentSchemeId` BIGINT(20) NOT NULL,
	`assessmentSchemeLevelId` BIGINT(20) NULL DEFAULT NULL,
	`assessmentEventId` BIGINT(20) NOT NULL,
	`validationOn` VARCHAR(50) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `mark_remark_idx1` (`jobId` ASC),
	INDEX `mark_remark_idx2` (`academicTermId` ASC),
	INDEX `mark_remark_idx3` (`courseId` ASC),
	INDEX `mark_remark_idx4` (`courseVariantId` ASC),
	INDEX `mark_remark_idx5` (`assessmentSchemeId` ASC),
	INDEX `mark_remark_idx6` (`assessmentSchemeLevelId` ASC),
	INDEX `mark_remark_idx7` (`assessmentEventId` ASC),
	INDEX `mark_remark_idx8` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_mark_remark_8` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240813151442__Create_import_marks_remarks_filter () $$ 
DROP PROCEDURE IF EXISTS V20240813151442__Create_import_marks_remarks_filter $$ 
DELIMITER ;