DELIMITER $$
DROP PROCEDURE IF EXISTS get_type_level_data_for_avg $$
CREATE PROCEDURE get_type_level_data_for_avg(admissionIds text,batchId bigint)
BEGIN
SELECT DISTINCT
    ranks.id AS id,
    ranks.admissionId AS admissionId,
    ranks.courseVariantId AS courseVariantId,
    eType.id AS levelId,
    period.programBatchId AS batchId,
    ranks.effectiveMarks AS effectiveMarks,
    ranks.obtainedMarks AS obtainedMarks,
    eType.evaluationType AS levelName
FROM
    evaluation_plan_level_one_rank ranks
        JOIN
    evaluation_plan_level_one levelOne ON levelOne.id = ranks.evaluationPlanLevelOneId
        JOIN
    evaluation_type eType ON eType.id = levelOne.evaluationTypeId
        JOIN
    course_variants cv ON cv.id = ranks.courseVariantId
        JOIN
    prog_batch_period_config period ON period.id = ranks.periodId
WHERE
    (ranks.whetherSpecialGrade IS NULL
        OR ranks.whetherSpecialGrade = FALSE)
        AND (cv.whetherTransferCredits IS NULL
        OR cv.whetherTransferCredits = FALSE)
        AND period.programBatchId = batchId
        AND FIND_IN_SET(ranks.admissionId, admissionIds);
END $$
DELIMITER ;