DELIMITER $$
DROP PROCEDURE IF EXISTS V20240923111314__Create_alumniManagementAllMain $$
CREATE PROCEDURE V20240923111314__Create_alumniManagementAllMain()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_users')) THEN	
CREATE TABLE `alumni_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `alumniCode` varchar(255) NOT NULL,
  `studentCode` varchar(255) DEFAULT NULL,
  `admissionCode` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) NOT NULL,
  `createdDate` datetime(6) NOT NULL,
  `password` varchar(255) NOT NULL,
  `encrypt` varchar(255) NOT NULL,
  `passwordResetRequired` bit(1) NOT NULL,
  `resetPassword` varchar(255) DEFAULT NULL,
  `failedLoginAttempts` int DEFAULT NULL,
  `accountLocked` bit(1) DEFAULT NULL,
  `lockExpiration` datetime(6) DEFAULT NULL,
  `whetherActive` bit(1) NOT NULL DEFAULT TRUE,
  `whetherDeleted` bit(1) NOT NULL DEFAULT FALSE,
  `messageAction` enum('NEW_USER_CREATION','RESET_PASSWORD') NOT NULL DEFAULT 'NEW_USER_CREATION',
  `messageStatus` enum('FAILURE','PENDING','SUCCESS') NOT NULL DEFAULT 'PENDING',
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UKdu0coq3asj6aq7likgtheqi0c` (`alumniCode`),
  UNIQUE KEY `UK9kulxugjxagb3f9ydjscxsdt8` (`emailId`),
  UNIQUE KEY `UKsasr078emxwa5tffv71uxfl4f` (`admissionCode`),
  UNIQUE KEY `UKte3wbd89dq1wk7bh7fp1xacl0` (`studentCode`),
  KEY `idx_alumni_users_alumniCode` (`alumniCode`),
  KEY `idx_alumni_users_studentCode` (`studentCode`),
  KEY `idx_alumni_users_admissionCode` (`admissionCode`),
  KEY `idx_alumni_users_composite_code` (`alumniCode`,`studentCode`,`admissionCode`),
  KEY `FKtf2px3r7kko8og4g0ykg23c4n` (`lastUpdatedBy`),
  CONSTRAINT `FKtf2px3r7kko8og4g0ykg23c4n` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB;
END IF;	
	
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_persons')) THEN	
CREATE TABLE `alumni_persons` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `signupCode` varchar(255) DEFAULT NULL,
  `salutationId` bigint DEFAULT NULL,
  `firstName` varchar(255) NOT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) NOT NULL,
  `gender` enum('FEMALE','MALE','OTHER') DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `emailId` varchar(255) NOT NULL,
  `phoneCountryCode` varchar(255) DEFAULT NULL,
  `mobileNumber` varchar(255) NOT NULL,
  `documentURL` varchar(255) DEFAULT NULL,
  `imageURL` varchar(255) DEFAULT NULL,
  `passoutYear` int DEFAULT NULL,
  `admissionCode` varchar(255) DEFAULT NULL,
  `studentCode` varchar(255) DEFAULT NULL,
  `alumniUserId` bigint DEFAULT NULL,
  `academyLocationId` bigint NOT NULL,
  `programId` bigint DEFAULT NULL,
  `otherProgramName` varchar(255) DEFAULT NULL,
  `batchId` bigint DEFAULT NULL,
  `otherBatchName` varchar(255) DEFAULT NULL,
  `status` enum('APPROVED','REJECTED','PENDING') DEFAULT 'PENDING',
  `reason` TEXT DEFAULT NULL,
  `personMessageAction` enum('APPROVED','REJECT') NOT NULL DEFAULT 'APPROVED',
  `messageStatus` enum('FAILURE','PENDING','SUCCESS') NOT NULL DEFAULT 'PENDING',
  `whetherDeleted` bit(1) NOT NULL DEFAULT FALSE,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UKmbv9eym7kumjs82rroq3ymhdd` (`emailId`),
  UNIQUE KEY `UKeeb61tnyahlciwaj8qu3pwpb2` (`mobileNumber`),
  UNIQUE KEY `UKf4fxmai9yad0cbjxmcbqmnx89` (`signupCode`),
  UNIQUE KEY `UKsbr4kxkaw1wg994trciag7kcr` (`admissionCode`),
  UNIQUE KEY `UKpmxff1aeosgrjtdigu5u9bjtj` (`studentCode`),
  UNIQUE KEY `UKexsbnwyvlne40xxtw1xso51e8` (`alumniUserId`),
  KEY `idx_alumni_persons_alumniUserId` (`alumniUserId`),
  KEY `FKpvc3o7bha8vbhrdq24p9w3qr` (`academyLocationId`),
  KEY `FKfa2kdh4xf71pb5dbuuoqxdewa` (`batchId`),
  KEY `FK1gcae1n78wkgv6tvl0r6tr6eg` (`lastUpdatedBy`),
  KEY `FKh766xqyqbl72u1m8h0edtm2ku` (`programId`),
  KEY `FK790ssd1tawx5bk790a68qpr41` (`salutationId`),
  CONSTRAINT `FK1gcae1n78wkgv6tvl0r6tr6eg` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK790ssd1tawx5bk790a68qpr41` FOREIGN KEY (`salutationId`) REFERENCES `salutations` (`id`),
  CONSTRAINT `FKc58jufuvjovrehif8a6yo3sec` FOREIGN KEY (`alumniUserId`) REFERENCES `alumni_users` (`id`),
  CONSTRAINT `FKfa2kdh4xf71pb5dbuuoqxdewa` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `FKh766xqyqbl72u1m8h0edtm2ku` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `FKpvc3o7bha8vbhrdq24p9w3qr` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
) ENGINE=InnoDB;
END IF;	

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_user_login_history')) THEN
CREATE TABLE `alumni_user_login_history` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `alumniUserId` bigint DEFAULT NULL,
  `accessToken` TEXT DEFAULT NULL,
  `browserName` varchar(255) DEFAULT NULL,
  `browserVersion` varchar(255) DEFAULT NULL,
  `ipAddress` varchar(255) DEFAULT NULL,
  `loginDeviceName` varchar(255) DEFAULT NULL,
  `loginTime` datetime(6) DEFAULT NULL,
  `logoutTime` datetime(6) DEFAULT NULL,
  `timeSpent` double DEFAULT NULL,
  `whetherTimeout` bit(1) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `FK51s0bfh1ll46vq50vviqw4xq0` (`alumniUserId`),
  CONSTRAINT `FK51s0bfh1ll46vq50vviqw4xq0` FOREIGN KEY (`alumniUserId`) REFERENCES `alumni_users` (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_id_sequence')) THEN
CREATE TABLE `alumni_id_sequence` (
  `id` bigint NOT NULL,
  `currentValue` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_message_report')) THEN
CREATE TABLE `alumni_message_report` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `msgType` enum('EMAIL','SMS') NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `recipient` varchar(255) NOT NULL,
  `contentPath` varchar(512) DEFAULT NULL,
  `messageStatus` enum('FAILURE','PENDING','SUCCESS') NOT NULL,
  `failureReason` varchar(500) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_funds')) THEN
CREATE TABLE `alumni_funds` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fundsCode` varchar(255) NOT NULL,
  `fundsTitle` varchar(255) NOT NULL,
  `currencyId` bigint NOT NULL,
  `donationGoal` bigint NOT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `imageUrl` varchar(255) DEFAULT NULL,
  `status` bit(1) NOT NULL DEFAULT b'1',
  `description` varchar(512) DEFAULT NULL,
   whetherDeleted BOOLEAN NOT NULL DEFAULT false,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UKpy2e24ldm9msr0kyv6frmxyim` (`fundsCode`),
  UNIQUE KEY `UK5qoo8yihd5dcx3fdpqr6pef94` (`fundsTitle`),
  KEY `FK93i8opsdcvw7gfe796na148jd` (`currencyId`),
  KEY `FK7xyqki3x8t670v49bv5vp8c10` (`lastUpdatedBy`),
  KEY `idx_alumni_funds_fundsTitle` (`fundsTitle`),
  CONSTRAINT `FK7xyqki3x8t670v49bv5vp8c10` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK93i8opsdcvw7gfe796na148jd` FOREIGN KEY (`currencyId`) REFERENCES `currency` (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_donation_range')) THEN
CREATE TABLE `alumni_donation_range` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `alumniFundsId` bigint NOT NULL,
  `minimumValue` double NOT NULL,
  `maximumValue` double NOT NULL,
  `lastUpdatedBy` BIGINT NULL default NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `FK6hm59lakn0qti6hruxsff8j04` (`alumniFundsId`),
  CONSTRAINT `FK6hm59lakn0qti6hruxsff8j04` FOREIGN KEY (`alumniFundsId`) REFERENCES `alumni_funds` (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_funds_academy_location_mapping')) THEN
CREATE TABLE `alumni_funds_academy_location_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `alumniFundsId` bigint NOT NULL,
  `academyLocationId` bigint NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `FKga5gl7tbrisgg7uigssphkjti` (`academyLocationId`),
  KEY `FKqtaio7sc3v38e6a6fpa7vw2qg` (`alumniFundsId`),
  KEY `FKr865vgpdf35dvf5k4xh8el764` (`lastUpdatedBy`),
  CONSTRAINT `FKga5gl7tbrisgg7uigssphkjti` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `FKqtaio7sc3v38e6a6fpa7vw2qg` FOREIGN KEY (`alumniFundsId`) REFERENCES `alumni_funds` (`id`),
  CONSTRAINT `FKr865vgpdf35dvf5k4xh8el764` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_payment')) THEN
CREATE TABLE `alumni_payment` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `alumniUserId` bigint NOT NULL,
  `alumniFundsId` bigint NOT NULL,
  `currencyId` bigint NOT NULL,
  `amount` double NOT NULL,
  `paymentEnitiateDate` datetime DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `paymentGateway` varchar(255) DEFAULT NULL,
  `transactionId` varchar(255) DEFAULT NULL,
  `paymentStatus` enum('CANCELLED','FAILED','PENDING','SUCCESS','TXN_SUCCESS') NOT NULL DEFAULT 'PENDING',
  `messageStatus` enum('SUCCESS','FAILURE','PENDING') NOT NULL DEFAULT 'PENDING',
  `receiptCode` varchar(255) DEFAULT NULL,
  `receiptPath` varchar(255) DEFAULT NULL,
  `alumniDonationRangeId` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UKjdpyaj4oovlncnaq3ft2qja1j` (`transactionId`),
  KEY `FKrbq86l52gd2vo1qdi6f9drhu5` (`alumniFundsId`),
  KEY `FKe61joltdpfqyqlnc9y7fiimhd` (`alumniUserId`),
  KEY `FKdm7nnfb6ufich61olu3iut8i4` (`currencyId`),
  CONSTRAINT `FKdm7nnfb6ufich61olu3iut8i4` FOREIGN KEY (`currencyId`) REFERENCES `currency` (`id`),
  CONSTRAINT  FKrbq86l52gd2vo1qdi6f9drrtd FOREIGN KEY (alumniDonationRangeId)  REFERENCES alumni_donation_range (id),
  CONSTRAINT `FKe61joltdpfqyqlnc9y7fiimhd` FOREIGN KEY (`alumniUserId`) REFERENCES `alumni_users` (`id`),
  CONSTRAINT `FKrbq86l52gd2vo1qdi6f9drhu5` FOREIGN KEY (`alumniFundsId`) REFERENCES `alumni_funds` (`id`)
) ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_professional_information')) THEN
CREATE TABLE alumni_professional_information (
    id BIGINT NOT NULL AUTO_INCREMENT,
    occupation VARCHAR(255) DEFAULT NULL,
    organization VARCHAR(255) DEFAULT NULL,
    designation VARCHAR(255) DEFAULT NULL,
    officialEmailId VARCHAR(255) DEFAULT NULL,
    phoneCountryCode VARCHAR(20) DEFAULT NULL,
    officialContactNumber VARCHAR(50) DEFAULT NULL,
    officialWebsiteLink VARCHAR(255) DEFAULT NULL,
    linkedInLink VARCHAR(255) DEFAULT NULL,
    twitterLink VARCHAR(255) DEFAULT NULL,
    about TEXT DEFAULT NULL,
    alumniPersonId BIGINT NOT NULL,
	lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (alumniPersonId) REFERENCES alumni_persons(id),
    UNIQUE KEY unique_officialEmailId (officialEmailId),
    UNIQUE KEY unique_officialContactNumber (officialContactNumber),
    UNIQUE KEY unique_linkedInLink (linkedInLink),
    UNIQUE KEY unique_twitterLink (twitterLink)
)ENGINE=InnoDB;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_address')) THEN 
CREATE TABLE `alumni_address` (
    id BIGINT NOT NULL AUTO_INCREMENT,
    alumniPersonId BIGINT DEFAULT NULL,
    addressType enum('PERSONAL','PROFESSIONAL','OTHER') DEFAULT NULL,
    isPrimary BOOLEAN DEFAULT FALSE,
    isCommunicationAddress BOOLEAN DEFAULT FALSE,
    isLegalAddress BOOLEAN DEFAULT FALSE,
    addressLine1 VARCHAR(255) DEFAULT NULL,
    addressLine2 VARCHAR(255) DEFAULT NULL,
    cityId BIGINT DEFAULT NULL,
    latitude VARCHAR(255) DEFAULT NULL,
    longitude VARCHAR(255) DEFAULT NULL,
    postalCode VARCHAR(255) DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (cityId) REFERENCES city(id),
    FOREIGN KEY (alumniPersonId) REFERENCES alumni_persons(id)
);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_setup')) THEN 
CREATE TABLE alumni_portal_setup (
    id bigint NOT NULL AUTO_INCREMENT,
    setupname VARCHAR(255) DEFAULT NULL,
    createdby BIGINT(20),
    createddate DATE,
    mappingstatus BOOLEAN DEFAULT false,
    status BOOLEAN DEFAULT false,
    createdfromalid BIGINT(30) NOT NULL,
    whetherDeleted boolean DEFAULT false,
    lastUpdate DATE,
    lastUpdatedBy BIGINT(20),
    PRIMARY KEY (id),
    FOREIGN KEY (createdby)
	REFERENCES users (id),
    FOREIGN KEY (lastUpdatedBy)
	REFERENCES users (id),
	CONSTRAINT fk_apply_to_details_academy_locations_new
	FOREIGN KEY (createdfromalid) 
	REFERENCES academy_location(id)
) ENGINE=InnoDB;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_modules')) THEN 
CREATE TABLE alumni_portal_modules (
    id bigint NOT NULL AUTO_INCREMENT ,
    module_name VARCHAR(255) DEFAULT NULL,
	module_code VARCHAR(255) DEFAULT NULL,
	form_alias_name VARCHAR(255) DEFAULT NULL,
	tableName VARCHAR(255) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    PRIMARY KEY (id),
    FOREIGN KEY (lastUpdatedBy)
	REFERENCES users (id)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_modules_setup')) THEN 
CREATE TABLE alumni_portal_modules_setup (
    id bigint NOT NULL AUTO_INCREMENT,
    module_name_id BIGINT(20) DEFAULT NULL,
    visibility BOOLEAN DEFAULT FALSE,
    mandatory BOOLEAN DEFAULT FALSE,
    sequenceNo INTEGER,
    new_module_name VARCHAR(255),
	setup_id BIGINT(20),
    lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    PRIMARY KEY (id),
    FOREIGN KEY (lastUpdatedBy)
	REFERENCES users (id),
    FOREIGN KEY (module_name_id)
	REFERENCES alumni_portal_modules (id),
	FOREIGN KEY (setup_id)
	REFERENCES alumni_portal_setup (id)
);
END IF;


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_applyTo')) THEN 
	CREATE TABLE alumni_portal_applyTo (
	id BIGINT(20) AUTO_INCREMENT ,
	alumni_portal_setup_id BIGINT(20) NOT NULL,
	academy_locations_id BIGINT(20) NOT NULL,
	whetherDeleted BOOLEAN default false,
	lastUpdate TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
	lastUpdatedBy BIGINT(20),
	PRIMARY KEY (id),
	CONSTRAINT fk_alumni_apply_to_details_portal_setup
	FOREIGN KEY (alumni_portal_setup_id) 
	REFERENCES alumni_portal_setup(id),
	CONSTRAINT fk_alumni_apply_to_academy_location
	FOREIGN KEY (academy_locations_id) 
	REFERENCES academy_location(id)
	);
END IF; 

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE table_schema = DATABASE() 
    AND table_name = 'form_field_display_settings' 
    AND column_name = 'alumniportalsetupid'
) THEN 
    ALTER TABLE `form_field_display_settings` 
    ADD COLUMN `alumniportalsetupid` BIGINT(20) DEFAULT NULL ,
    ADD INDEX `idx_alumni_portalsetupid` (`alumniportalsetupid` ASC);

    ALTER TABLE `form_field_display_settings` 
    ADD CONSTRAINT `fk_form_field_display_alumniportalsetupid`
    FOREIGN KEY (`alumniportalsetupid`)
    REFERENCES `alumni_portal_setup` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT;
END IF;
    
IF NOT EXISTS (SELECT * 
               FROM information_schema.tables 
               WHERE table_schema = DATABASE() 
               AND table_name = 'alumni_notification') THEN
    CREATE TABLE `alumni_notification` (
        `id` bigint NOT NULL AUTO_INCREMENT,
        `title` varchar(255) DEFAULT NULL,
        `description` varchar(255) DEFAULT NULL,
        `createdDate` datetime DEFAULT NULL,
        `isReadNotification` boolean DEFAULT false,
        `alumniUserId` bigint NOT NULL,
        `alumniMessageReportId` BIGINT NULL DEFAULT NULL,
        `notificationType` enum('RESET_PASSWORD', 'FORGET_PASSWORD', 'NEWS_AND_FEEDS','DONATION','EVENTS','GALLERY') NULL DEFAULT NULL,
        `lastUpdatedBy` bigint DEFAULT NULL,
        `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        INDEX `idx_alumni_notification_recipient_id` (`alumniUserId`),
        INDEX `idx_alumni_notification_read_status` (`isReadNotification`),
        PRIMARY KEY (`id`),
        KEY `FK_alumni_notification_lastUpdatedBy` (`lastUpdatedBy`),
        CONSTRAINT `FK_alumni_notification_lastUpdatedBys` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
        CONSTRAINT `FK_alumni_notification_alumniUserId` FOREIGN KEY (`alumniUserId`) REFERENCES `alumni_users` (`id`),
        CONSTRAINT `FK_alumni_notification_alumniMessageReportId` FOREIGN KEY (`alumniMessageReportId`) REFERENCES `alumni_message_report` (`id`)
    ) ENGINE=InnoDB;
END IF;


IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_portal_modules')) THEN 
    insert into alumni_portal_modules(module_code,module_name,form_alias_name,lastUpdate,lastUpdatedBy) values ("STEP1_DASHBOARD","Dashboard",null,now(),1), ("STEP2_MYPROFILE","My Profile",null,now(),1), ("STEP3_INTEREST_GROUP","Interest Group",null,now(),1),    
    ("STEP4_EVENTS","Events",null,now(),1), ("STEP5_DONATE_FUNDS","Donate Funds",null,now(),1), ("STEP6_GALLERY","Gallery",null,now(),1),
    ("STEP7_ALUMNI_DIRECTORY","Alumni Directory",null,now(),1),("STEP8_PERSONAL_INFORMATION","Personal Information","alumnipersonalinformationform",now(),1),("STEP9_PROFESSIONAL_INFORMATION","Professional Information","alumniprofessionaldetailform",now(),1),
    ("STEP10_EDUCATION_DETAIL","Education Detail","alumnieducationhistoryform",now(),1),("STEP11_ADDRESS","Address","alumniAddressForm",now(),1),("STEP12_NOTIFICATIONS","Notifications",null,now(),1),("STEP13_NEWS_AND_FEEDS","News and Feeds",null,now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_news_and_feeds')) THEN 
CREATE TABLE alumni_news_and_feeds (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(255) NOT NULL UNIQUE,
    title VARCHAR(255) NOT NULL UNIQUE,
    startDate DATE DEFAULT NULL,
    startTime TIME DEFAULT NULL,
    endDate DATE DEFAULT NULL,
    endTime TIME DEFAULT NULL,
    description TEXT DEFAULT NULL,
    imageUrl VARCHAR(255) DEFAULT NULL,
    status ENUM('PUBLISHED','UNPUBLISHED') NOT NULL DEFAULT 'UNPUBLISHED', 
    lastUpdatedBy BIGINT NOT NULL,  
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    whetherDeleted BOOLEAN NOT NULL DEFAULT FALSE, 
    CONSTRAINT FK9lrmwq72g2j7v5hbr8fgp63t7 FOREIGN KEY (lastUpdatedBy) REFERENCES users(id) ,
     CONSTRAINT UQ_alumni_news_and_feeds_code UNIQUE (code),
    CONSTRAINT UQ_alumni_news_and_feeds_title UNIQUE (title)
)ENGINE=InnoDB;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_news_and_feeds_mapping')) THEN 
CREATE TABLE alumni_news_and_feeds_mapping (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    alumniNewsAndFeedsId BIGINT NOT NULL,
    academyLocationId BIGINT NOT NULL,
    programId BIGINT DEFAULT NULL,
    batchId BIGINT DEFAULT NULL,
    passoutYear INT DEFAULT NULL,
    lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP NOT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,

    -- Foreign key constraints
    CONSTRAINT FK_alumni_news_and_feeds_mapping_alumni_news FOREIGN KEY (alumniNewsAndFeedsId) REFERENCES alumni_news_and_feeds(id),
    CONSTRAINT FK_alumni_news_and_feeds_mapping_academy_location FOREIGN KEY (academyLocationId) REFERENCES academy_location(id),
    CONSTRAINT FK_alumni_news_and_feeds_mapping_program FOREIGN KEY (programId) REFERENCES programs(id),
    CONSTRAINT FK_alumni_news_and_feeds_mapping_batch FOREIGN KEY (batchId) REFERENCES batches(id),
    CONSTRAINT FK_alumni_news_and_feeds_mapping_last_updated_by FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
)ENGINE=INNODB;
CREATE INDEX idx_alumni_news_and_feeds_mapping_academy_location ON alumni_news_and_feeds_mapping(academyLocationId);
END IF; 

IF NOT EXISTS (SELECT * 
                   FROM information_schema.tables 
                   WHERE table_schema = DATABASE() 
                   AND table_name = 'alumni_user_news_feeds_restriction') THEN
        CREATE TABLE `alumni_user_news_feeds_restriction` (
            `id` bigint NOT NULL AUTO_INCREMENT,
            `alumniUserId` bigint NOT NULL,
            `alumniNewsAndFeedsMappingId` bigint NOT NULL,
            `lastUpdatedBy` bigint DEFAULT NULL,
            `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `FK_lastUpdatedBys` (`lastUpdatedBy`),
            CONSTRAINT `FK__lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
            CONSTRAINT `FK__alumniUserId` FOREIGN KEY (`alumniUserId`) REFERENCES `alumni_users` (`id`),
			CONSTRAINT `FK_alumniNewsAndFeedsMappingIdId` FOREIGN KEY (`alumniNewsAndFeedsMappingId`) REFERENCES `alumni_news_and_feeds_mapping` (`id`)
        ) ENGINE=InnoDB;
END IF;



SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
IF NOT EXISTS (select * from id_column_available where tableName='alumni_news_and_feeds' and columnName='code') THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('alumni_news_and_feeds','code');

IF NOT EXISTS (select * from id_entity_setting where tableName='alumni_news_and_feeds' and idGenerationTable='alumni_news_and_feeds' and whetherFullyConfigurable=TRUE and dynanicFieldAvailable=FALSE and searchConfigCode is NULL) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) 
VALUES('alumni_news_and_feeds','alumni_news_and_feeds',TRUE,FALSE,NULL,1,@currentTimeStamp);
END IF;
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);

IF NOT EXISTS (select * from id_definition where idEntitySettingId=@idEntitySettingId and idFormatType='ALPHA_NUMERIC' AND idColumn='code') THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) 
VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','code',0,0,1,@currentTimeStamp,0);
END IF;

SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
IF NOT EXISTS (SELECT * FROM id_format where idDefinitionId=@idDefinitionId and seqNo=1) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
END IF;

SET @idFormat=(SELECT MAX(id) FROM id_format);
IF NOT EXISTS (SELECT * FROM id_format_alphanumeric WHERE id=@idFormat and prefix='NAF' and suffix='' and startFrom=1) THEN
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'NAF','',1);
END IF;

END IF;




SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
IF NOT EXISTS (select * from id_column_available where tableName='alumni_funds' and columnName='fundsCode') THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('alumni_funds','fundsCode');

IF NOT EXISTS (select * from id_entity_setting where tableName='alumni_funds' and idGenerationTable='alumni_funds' and whetherFullyConfigurable=TRUE and dynanicFieldAvailable=FALSE and searchConfigCode is NULL) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) 
VALUES('alumni_funds','alumni_funds',TRUE,FALSE,NULL,1,@currentTimeStamp);
END IF;
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);

IF NOT EXISTS (select * from id_definition where idEntitySettingId=@idEntitySettingId and idFormatType='ALPHA_NUMERIC' AND idColumn='fundsCode') THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) 
VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','fundsCode',0,0,1,@currentTimeStamp,0);
END IF;

SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
IF NOT EXISTS (SELECT * FROM id_format where idDefinitionId=@idDefinitionId and seqNo=1) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
END IF;

SET @idFormat=(SELECT MAX(id) FROM id_format);
IF NOT EXISTS (SELECT * FROM id_format_alphanumeric WHERE id=@idFormat and prefix='FUND' and suffix='' and startFrom=1) THEN
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'FUND','',1);
END IF;

END IF;


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

IF NOT EXISTS (select * from id_column_available where tableName='alumni_users' and columnName='code') THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('alumni_users','alumniCode');

IF NOT EXISTS (select * from id_entity_setting where tableName='alumni_users' and idGenerationTable='alumni_users' and whetherFullyConfigurable=TRUE and dynanicFieldAvailable=FALSE and searchConfigCode is NULL) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) 
VALUES('alumni_users','alumni_users',TRUE,FALSE,NULL,1,@currentTimeStamp);
END IF;
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);

IF NOT EXISTS (select * from id_definition where idEntitySettingId=@idEntitySettingId and idFormatType='ALPHA_NUMERIC' AND idColumn='alumniCode') THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) 
VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','alumniCode',0,0,1,@currentTimeStamp,0);
END IF;


SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
IF NOT EXISTS (SELECT * FROM id_format where idDefinitionId=@idDefinitionId and seqNo=1) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
END IF;

SET @idFormat=(SELECT MAX(id) FROM id_format);
IF NOT EXISTS (SELECT * FROM id_format_alphanumeric WHERE id=@idFormat and prefix='ALU' and suffix='' and startFrom=1) THEN
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'ALU','',1);
END IF;

END IF;



IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_committee')) THEN 
CREATE TABLE `alumni_committee` (
    id BIGINT NOT NULL AUTO_INCREMENT,
    committeeCode VARCHAR(255) DEFAULT NULL,
    committeeName VARCHAR(255) DEFAULT NULL,
    committeeCoordinator BIGINT NOT NULL,
    validFromDate DATE DEFAULT NULL,
    validTillDate DATE DEFAULT NULL,
    status BOOLEAN DEFAULT FALSE,
    description TEXT DEFAULT NULL,
    academyLocationId BIGINT NOT NULL,
    committeeTypeId BIGINT NOT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (committeeCoordinator) REFERENCES users(id),
    FOREIGN KEY (academyLocationId) REFERENCES academy_location(id),
	FOREIGN KEY (committeeTypeId) REFERENCES committee_type(id)
);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_committee_participant')) THEN
CREATE TABLE `alumni_committee_participant` (
    id BIGINT NOT NULL AUTO_INCREMENT,
    alumniCommitteeId BIGINT NOT NULL,
	participantId BIGINT DEFAULT NULL,
    alumniParticipantId BIGINT DEFAULT NULL,
    status enum('JOINED','AVAILABLE') DEFAULT 'AVAILABLE',
	fromDate DATE DEFAULT NULL,
	toDate  DATE DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (alumniCommitteeId) REFERENCES alumni_committee(id),
    FOREIGN KEY (participantId) REFERENCES users(id),
	FOREIGN KEY (alumniParticipantId) REFERENCES alumni_users(id)
);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='alumni_committee_academy_location')) THEN
    CREATE TABLE `alumni_committee_academy_location` (
    id BIGINT NOT NULL AUTO_INCREMENT,
    alumniCommitteeId BIGINT NOT NULL,
    academyLocationId BIGINT DEFAULT NULL,
	programId BIGINT DEFAULT NULL,
	batchId BIGINT DEFAULT NULL,
    lastUpdatedBy BIGINT DEFAULT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    FOREIGN KEY (alumniCommitteeId) REFERENCES alumni_committee(id),
    FOREIGN KEY (academyLocationId) REFERENCES academy_location(id),
	FOREIGN KEY (programId) REFERENCES programs(id),
	FOREIGN KEY (batchId) REFERENCES batches(id)
);
END IF;


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='resource_booking_alumni_users')) THEN 
CREATE TABLE IF NOT EXISTS `resource_booking_alumni_users` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `alumniUserId` BIGINT(50) NOT NULL,
    `resourceBookingId` BIGINT(50) NOT NULL,
     isRegistered BOOLEAN DEFAULT FALSE,
     messageStatus enum('SUCCESS','FAILURE','PENDING') DEFAULT 'PENDING',
     eventMessageAction enum('EVENT_CREATION','EVENT_REGISTRATION') DEFAULT NULL,
    `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `fk_alumni_user_idx` (`alumniUserId` ASC),
    
    CONSTRAINT `fk_alumni_users_resource`
        FOREIGN KEY (`alumniUserId`)
        REFERENCES `alumni_users` (`id`),
        
	CONSTRAINT `fk_alumni_resource`
        FOREIGN KEY (`resourceBookingId`)
        REFERENCES `resource_bookings` (`id`)
);

END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='resource_bookings' and column_name='isCheckAlumni')) THEN
ALTER TABLE resource_bookings
ADD COLUMN isCheckAlumni BOOLEAN DEFAULT FALSE;
END IF;

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsGrid',1,
'[{"id":null,"columnName":"News ID","dataIndex":"code","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"Title","dataIndex":"title","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"Description","dataIndex":"description","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"Start Date","dataIndex":"alumniStartDate","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"End Date","dataIndex":"alumniEndDate","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"Status","dataIndex":"status","columnVisibility":"SHOW","sequence":3,"mandatory":false}
]'
  ,now(),1);
END IF; 
IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalSetUpGrid' and portalId=1)) THEN 
INSERT INTO data_grid
(gridName,portalId,jsonObject,lastUpdate,lastUpdatedBy)
VALUES
('Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalSetUpGrid',1,
'[{"id":null,"columnName":"Alumni Setup Name","dataIndex":"setupName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"Created By","dataIndex":"printName","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"Creation Date","dataIndex":"createdDate","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"Mapping Status","dataIndex":"mappingStatus","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"Status","dataIndex":"status","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"Academy Location","dataIndex":"countOfAL","columnVisibility":"SHOW","sequence":3,"mandatory":false}
]'
  ,now(),1);	
END IF;

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.alumniList.alumniListGrid' AND portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.alumniSystem.alumniList.alumniListGrid',1, '[
{"id":null,"columnName":"ALUMNI_CODE","dataIndex":"alumniCode","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"ALUMNI_NAME","dataIndex":"alumniName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"GENDER","dataIndex":"gender","columnVisibility":"HIDE","sequence":4,"mandatory":false},
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocationName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"PROGRAM_NAME","dataIndex":"programName","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"BATCH_NAME","dataIndex":"batchName","columnVisibility":"HIDE","sequence":7,"mandatory":false},
{"id":null,"columnName":"EMAIL_ID","dataIndex":"emailId","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"MOBILE_NO","dataIndex":"mobileNo","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"PASSOUT_YEAR","dataIndex":"passOutYear","columnVisibility":"SHOW","sequence":10,"mandatory":false},
{"id":null,"columnName":"DATE_OF_BIRTH","dataIndex":"alumniDateOfBirth","columnVisibility":"SHOW","sequence":11,"mandatory":false}]',
now(),1);
END IF; 

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.alumniSystem.signUpRequest.SignUpRequestGrid' AND portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.alumniSystem.signUpRequest.SignUpRequestGrid',1, '[
{"id":null,"columnName":"NAME","dataIndex":"alumniName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"MOBILE_NUMBER","dataIndex":"mobileNumber","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"EMAIL_ID","dataIndex":"emailId","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"GENDER","dataIndex":"gender","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"DATE_OF_BIRTH","dataIndex":"alumniDateOfBirth","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocationName","columnVisibility":"HIDE","sequence":7,"mandatory":false},
{"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"HIDE","sequence":8,"mandatory":false},
{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"PASSOUT_YEAR","dataIndex":"passOutYear","columnVisibility":"SHOW","sequence":10,"mandatory":false},
{"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":11,"mandatory":false},
{"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionCode","columnVisibility":"SHOW","sequence":12,"mandatory":false},
{"id":null,"columnName":"STATUS","dataIndex":"alumniStatus","columnVisibility":"SHOW","sequence":13,"mandatory":false},
{"id":null,"columnName":"REMARKS","dataIndex":"reason","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"SIGNUP_REQUEST_ID","dataIndex":"signupCode","columnVisibility":"SHOW","sequence":15,"mandatory":false},
{"id":null,"columnName":"DOCUMENTS","dataIndex":"documentURL","columnVisibility":"SHOW","sequence":16,"mandatory":false}]',
now(),1);
END IF;

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsGrid',1,
'[{"id":null,"columnName":"ALUMNI_NAME","dataIndex":"alumniName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"ALUMNI_ID","dataIndex":"alumniCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocationName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"REGISTRATION_DATE","dataIndex":"registrationDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
]'
  ,now(),1);
END IF;   

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.committee.committee.AlumniCommitteeGrid' and portalId=1)) THEN 
INSERT INTO `data_grid`
(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.committee.committee.AlumniCommitteeGrid',1,
'[{"id":null,"columnName":"COMMITTEE_CODE","dataIndex":"committeeCode","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"COMMITTEE_TYPE","dataIndex":"committeeTypeValue","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"COMMITTEE_NAME","dataIndex":"committeeName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"COMMITTEE_CO_ORDINATOR","dataIndex":"committeeCoordinatorName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"DESCRIPTION","dataIndex":"description","columnVisibility":"SHOW","sequence":3,"mandatory":false},
]'
  ,now(),1);
END IF; 

IF NOT EXISTS ((select id from privilege where id=868)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('868', '0', 'Alumni Radio Committee', 'ALUMNI_RADIO_COMMITTEE', 'ALUMNI_RADIO_COMMITTEE', 'Alumni Radio Committee', '1', now());
END IF;

IF NOT EXISTS ((select id from privilege where id=849)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('849', '0', 'Publish', 'PUBLISH', 'PUBLISH', 'Publish', '1', now());
END IF;

IF NOT EXISTS ((select id from privilege where id=850)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('850', '0', 'Unpublish', 'UNPUBLISH', 'UNPUBLISH', 'Unpublish', '1', now());
END IF;

IF NOT EXISTS ((select id from privilege where id=844)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('844', '0', 'View Transactions', 'VIEW_TRANSACTIONS', 'VIEW_TRANSACTIONS', 'View Transactions', '1', now());
END IF; 

IF NOT EXISTS ((select id from privilege where id=856)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('856', '0', 'Alumni Checkbox', 'Alumni Checkbox', 'ALUMNI_CHECKBOX', 'Alumni Checkbox', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='alumni_gallery_batch_mapping')) THEN 
CREATE TABLE IF NOT EXISTS `alumni_gallery_batch_mapping` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `galleryId` BIGINT(20) NOT NULL,
    `batchId` BIGINT(20) NULL DEFAULT NULL,
    `programId` BIGINT(20) NULL DEFAULT NULL,
    `academyLocationId` BIGINT(20) NULL DEFAULT NULL,
    `isSharedWithAlumni` BIT(1) NOT NULL DEFAULT b'0', 
     messageStatus enum('SUCCESS','FAILURE','PENDING') DEFAULT 'PENDING',
     galleryCreationAction enum('GALLERY_CREATION') DEFAULT 'GALLERY_CREATION',
    `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `fk_gallery_idx` (`galleryId` ASC),
    INDEX `fk_batch_idx` (`batchId` ASC),
    INDEX `fk_program_idx` (`programId` ASC),
    INDEX `fk_academy_location_idx` (`academyLocationId` ASC),
    
    CONSTRAINT `fk_alumni_gallery`
        FOREIGN KEY (`galleryId`)
        REFERENCES `gallery` (`id`)
        ON DELETE NO ACTION
        ON UPDATE NO ACTION
);

END IF;

IF NOT EXISTS ((select id from privilege where id=871)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('871', '0', 'Alumni View Modal', 'Alumni View Modal', 'ALUMNI_VIEW_MODAL', 'Alumni View Modal', '1', now());
END IF;

IF NOT EXISTS ((select id from privilege where id=853)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('853', '0', 'Alumni Event Tab', 'ALUMNI_EVENT_TAB', 'ALUMNI_EVENT_TAB', 'Alumni Event Tab', '1', now());
END IF;


IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'admissionCodeIteamId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','admissionCode','admissionCodeIteamId','textfield',1,1,NULL,1,now(),'Alumni Id','1','Alumni Personal Details','Create, Edit, and View','Alumni ID',0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'studentId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','studentId','studentId','textfield',1,1,NULL,1,now(),'Student ID','1','Alumni Personal Details','Create, Edit, and View','Student ID',0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'admissionId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','admissionId','admissionId','textfield',1,1,NULL,1,now(),'Admission ID','1','Alumni Personal Details','Create, Edit, and View','Admission ID',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'alumniPhotoUploadForm')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','alumniPhotoUploadForm','alumniPhotoUploadForm','photouploadform',0,0,NULL,1,now(),'photo Image','1','Alumni Personal Details','Create, Edit, and View','upload Image',0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'salutation')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','salutation','salutation','nestedJsonCombo',1,1,NULL,1,now(),'Salutation','1','Alumni Personal Details','Create, Edit, and View','Salutation',0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'firstName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','firstName','firstName','textfield',1,1,NULL,1,now(),'First Name','1','Alumni Personal Details','Create, Edit, and View','First Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'middleName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','middleName','middleName','textfield',0,0,NULL,1,now(),'Middle Name','1','Alumni Personal Details','Create, Edit, and View','Middle Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'lastName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','lastName','lastName','textfield',1,1,NULL,1,now(),'Last Name','1','Alumni Personal Details','Create, Edit, and View','Last Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'printName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','printName','printName','textfield',0,0,NULL,1,now(),'Print Name','1','Alumni Personal Details','Create, Edit, and View','Print Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'mobileNoFldItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','mobileNoFld','mobileNoFldItemId','fieldcontainer',1,1,NULL,1,now(),'Mobile No','1','Alumni Personal Details','Create, Edit, and View','Address Mobile No',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'emailId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','emailId','emailId','textfield',1,1,NULL,1,now(),'Email ID','1','Alumni Personal Details','Create, Edit, and View','Email ID',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'gender')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','gender','gender','nestedJsonCombo',1,1,NULL,1,now(),'Gender','1','Alumni Personal Details','Create, Edit, and View','Gender',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnipersonalinformationform' and formFieldId = 'birthDate')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnipersonalinformationform','birthDate','birthDate','datefield',1,1,NULL,1,now(),'Date Of Birth','1','Alumni Personal Details','Create, Edit, and View','Date Of Birth',0);
END IF;





IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnieducationhistoryform' and formFieldId = 'academyLocationItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnieducationhistoryform','academyLocation','academyLocationItemId','customcombobox',1,1,NULL,1,now(),'Academy Location Name','1','Alumni Educational Details','Create, Edit, and View','Academy Location Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnieducationhistoryform' and formFieldId = 'programItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnieducationhistoryform','program','programItemId','customcombobox',1,1,NULL,1,now(),'Program Name','1','Alumni Educational Details','Create, Edit, and View','Program Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnieducationhistoryform' and formFieldId = 'batchItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnieducationhistoryform','batch','batchItemId','customcombobox',1,1,NULL,1,now(),'Batch Name','1','Alumni Educational Details','Create, Edit, and View','Batch Name',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumnieducationhistoryform' and formFieldId = 'passoutYearItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumnieducationhistoryform','passoutYear','passoutYearItemId','textfield',1,1,NULL,1,now(),'Passout Year','1','Alumni Educational Details','Create, Edit, and View','Passout Year',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'occupationIteamId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','occupation','occupationIteamId','textfield',0,0,NULL,1,now(),'Occupation','1','Alumni Professional Details','Create, Edit, and View','Occupation',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'organizationItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','organization','organizationItemId','textfield',0,0,NULL,1,now(),'Organization','1','Alumni Professional Details','Create, Edit, and View','Organization',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'designationItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','designation','designationItemId','textfield',0,0,NULL,1,now(),'Designation','1','Alumni Professional Details','Create, Edit, and View','Designation',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'emailItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','email','emailItemId','textfield',0,0,NULL,1,now(),'Email ID','1','Alumni Professional Details','Create, Edit, and View','Email ID',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'contactNoItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','contactNo','contactNoItemId','numberfield',0,0,NULL,1,now(),'Contact No','1','Alumni Professional Details','Create, Edit, and View','Contact No',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'websiteItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','website','websiteItemId','textfield',0,0,NULL,1,now(),'Official Website','1','Alumni Professional Details','Create, Edit, and View','Official Website',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'linkedInItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','linkedIn','linkedInItemId','textfield',0,0,NULL,1,now(),'LinkedIn URL','1','Alumni Professional Details','Create, Edit, and View','LinkedIn URL',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'twitterItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','twitter','twitterItemId','textfield',0,0,NULL,1,now(),'X','1','Alumni Professional Details','Create, Edit, and View','X',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniprofessionaldetailform' and formFieldId = 'aboutItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniprofessionaldetailform','about','aboutItemId','textfield',0,0,NULL,1,now(),'About','1','Alumni Professional Details','Create, Edit, and View','About',0);
END IF;




IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'communicationAddressItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','isPrimary','communicationAddressItemId','checkboxfield',0,0,NULL,1,now(),'Is Communication Address','1','Alumni Address Details','Create, Edit, and View','Is Communication Address',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'legalAddressItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','isLegalAddress','legalAddressItemId','checkboxfield',0,0,NULL,1,now(),'Is Legal Address','1','Alumni Address Details','Create, Edit, and View','Is Legal Address',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'addressLine1')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','addressLine1','addressLine1','textareafield',1,1,NULL,1,now(),'addressLine 1','1','Alumni Address Details','Create, Edit, and View','addressLine 1',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'addressLine2')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','addressLine2','addressLine2','textareafield',0,0,NULL,1,now(),'addressLine 1','1','Alumni Address Details','Create, Edit, and View','addressLine 1',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'cityId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','cityId','cityId','customcombobox',1,1,NULL,1,now(),'City','1','Alumni Address Details','Create, Edit, and View','City',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'country')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','countryId','country','customcombobox',1,1,NULL,1,now(),'country','1','Country','Create, Edit, and View','country',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'parentCountryRegion')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','countryRegionId','parentCountryRegion','customcombobox',1,1,NULL,1,now(),'Country Region','1','Country','Create, Edit, and View','Country Region',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'pincodeId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','pincode','pincodeId','textfield',0,0,NULL,1,now(),'pincode','1','Alumni Address Details','Create, Edit, and View','pincode',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'geographicalAreaContainer')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','geographicalAreaContainer','geographicalAreaContainer','fieldcontainer',0,0,NULL,1,now(),'Geographical Area','1','Alumni Address Details','Create, Edit, and View','Geographical Area',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'latitudeItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','Latitude','latitudeItemId','textfield',0,0,NULL,1,now(),'Latitude','1','Alumni Address Details','Create, Edit, and View','Latitude',0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'alumniAddressForm' and formFieldId = 'longitude')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('alumniAddressForm','longitude','longitude','textfield',0,0,NULL,1,now(),'Longitude','1','Alumni Address Details','Create, Edit, and View','Longitude',0);
END IF;

IF NOT EXISTS ((select id from privilege where id=835)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) VALUES ('835', '0', 'MakeAlumni', 'MAKEALUMNI_BTN', 'MAKEALUMNI_BTN', 'MakeAlumni', '1', now());
END IF;
 

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE `screenName` ='Import Bulk Alumni' AND `code` ='importBulkAlumni')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
VALUES ('Import Bulk Alumni', 'alumni/importBulkAlumni', 'importBulkAlumni', '1');
END IF;  

SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='importBulkAlumni');

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SALUTATION_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('SALUTATION_HEADER', 'Salutation', 'Salutation', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FIRST_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('FIRST_NAME_HEADER', 'First Name', 'First Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MIDDLE_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('MIDDLE_NAME_HEADER', 'Middle Name', 'Middle Name', '1', now(), '1', '1', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='LAST_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('LAST_NAME_HEADER', 'Last Name', 'Last Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COUNTRY_CODE_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COUNTRY_CODE_HEADER', 'Country Code', 'Country Code', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MOBILE_NO_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('MOBILE_NO_HEADER', 'Mobile No', 'Mobile No', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='EMAIL_ID_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('EMAIL_ID_HEADER', 'Email-ID', 'Email-ID', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='GENDER_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('GENDER_HEADER', 'Gender', 'Gender', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DATE_OF_BIRTH_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('DATE_OF_BIRTH_HEADER', 'Date Of Birth', 'Date Of Birth', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ACADEMY_LOCATION_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='PROGRAM_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('PROGRAM_HEADER', 'Program', 'Program', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BATCH_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('BATCH_HEADER', 'Batch', 'Batch', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='PASSOUT_YEAR_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('PASSOUT_YEAR_HEADER', 'Passout Year', 'Passout Year', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STUDENT_ID_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('STUDENT_ID_HEADER', 'Student ID', 'Student ID', '1', now(), '1', '1', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ADMISSION_ID_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('ADMISSION_ID_HEADER', 'Admission ID', 'Admission ID', '1', now(), '1', '0', '1', @importUtilityMasterId, '1', NULL);
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SALUTATION_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('SALUTATION_HEADER', 'Salutation', 'Salutation', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FIRST_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('FIRST_NAME_HEADER', 'First Name', 'First Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MIDDLE_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('MIDDLE_NAME_HEADER', 'Middle Name', 'Middle Name', '0', now(), '1', '1', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='LAST_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('LAST_NAME_HEADER', 'Last Name', 'Last Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COUNTRY_CODE_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COUNTRY_CODE_HEADER', 'Country Code', 'Country Code', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MOBILE_NO_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('MOBILE_NO_HEADER', 'Mobile No', 'Mobile No', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='EMAIL_ID_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('EMAIL_ID_HEADER', 'Email-ID', 'Email-ID', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='GENDER_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('GENDER_HEADER', 'Gender', 'Gender', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DATE_OF_BIRTH_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('DATE_OF_BIRTH_HEADER', 'Date Of Birth', 'Date Of Birth', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ACADEMY_LOCATION_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='PROGRAM_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('PROGRAM_HEADER', 'Program', 'Program', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BATCH_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('BATCH_HEADER', 'Batch', 'Batch', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='PASSOUT_YEAR_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('PASSOUT_YEAR_HEADER', 'Passout Year', 'Passout Year', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STUDENT_ID_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('STUDENT_ID_HEADER', 'Student ID', 'Student ID', '0', now(), '1', '1', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ADMISSION_ID_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('ADMISSION_ID_HEADER', 'Admission ID', 'Admission ID', '0', now(), '1', '1', '0', @importUtilityMasterId, '1', NULL);
END IF;


IF NOT EXISTS ((select id from privilege where id=847)) THEN 
INSERT INTO privilege (id, version, description, displayCode, code, privilegeName, lastUpdatedBy, lastUpdate) 
VALUES ('847', '0', 'Import Alumni', 'IMPORT_ALUMNI', 'IMPORT_ALUMNI', 'Import Alumni', '1', now());
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'mapalbumstructure' and formFieldId = 'alumniRadioItemId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('mapalbumstructure','rb','alumniRadioItemId','checkboxgroup',0,0,NULL,1,now(),'Alumni','','MapAlbumStructure','Create, Edit, and View','Alumni',0);
END IF;

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * FROM `form_field_info` where formAliasName ='mapalbumstructure' and formFieldId ='alumniRadioItemId')) THEN 
update form_field_info set formFieldName ='rbAlumni' where formAliasName ='mapalbumstructure' and formFieldId ='alumniRadioItemId';
END IF; 
SET SQL_SAFE_UPDATES=1;


END $$
CALL V20240923111314__Create_alumniManagementAllMain () $$ 
DROP PROCEDURE IF EXISTS V20240923111314__Create_alumniManagementAllMain $$ 
DELIMITER ;