DELIMITER $$
DROP PROCEDURE IF EXISTS V20241002105231__Create_batchResultStatus $$
CREATE PROCEDURE V20241002105231__Create_batchResultStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='batch_result_status')) THEN 
CREATE TABLE `batch_result_status` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `batchResultStatusId` BIGINT(20) NULL,
  `batchId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_batch_result_status_idx` (`batchResultStatusId` ASC),
  INDEX `fk_batchId_idx` (`batchId` ASC) ,
  INDEX `fk_batchResultStatuslastUpdateBy_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `fk_batch_result_status`
    FOREIGN KEY (`batchResultStatusId`)
    REFERENCES `transfer_credit_result_status_csm` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_batchId`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_batchResultStatuslastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20241002105231__Create_batchResultStatus () $$ 
DROP PROCEDURE IF EXISTS V20241002105231__Create_batchResultStatus $$ 
DELIMITER ;