DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003174119__Create_Stripe_ChildCSM $$
CREATE PROCEDURE V20241003174119__Create_Stripe_ChildCSM()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='stripe'))) THEN
CREATE TABLE `stripe` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `standardPaymentGatewayId` BIGINT(20) NULL,
        `academyLocation` varchar(255) NOT NULL,
        `publicKey` varchar(255) NOT NULL,
        `secretKey` varchar(255) NOT NULL,
  `environment` varchar(255) NOT NULL,
        `currencyCode` varchar(255) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
`lastUpdatedBy` bigint(20) NOT NULL,
PRIMARY KEY (`id`),
INDEX `fk_stripe_id_idx` (`standardPaymentGatewayId` ASC),
INDEX `fk_stripe_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_stripe_id_idx`
   FOREIGN KEY (`standardPaymentGatewayId`)
   REFERENCES `standard_payment_gateway` (`id`)
   ON DELETE RESTRICT
   ON UPDATE RESTRICT,
  CONSTRAINT `fk_stripe_lastUpdatedBy_user_id_idx`
   FOREIGN KEY (`lastUpdatedBy`)
   REFERENCES `users` (`id`)
   ON DELETE RESTRICT
   ON UPDATE RESTRICT
) ;
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'stripe')) THEN
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@standardMasterMaxId+1, 'stripe','STRIPE','Fees & Payments','COMMON_MASTER',1,0,1,SYSDATE());

SET SQL_SAFE_UPDATES = 0;
SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='stripe');
UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='standard_payment_gateway';
        UPDATE  `standard_payment_gateway` SET `itemCode` = @standardMasterId WHERE (itemValue = 'stripe');
SET SQL_SAFE_UPDATES = 1;


   SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'academyLocation', 'Academy Location', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'publicKey', 'publicKey', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'secretKey', 'secretKey', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'environment', 'Environment', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1',SYSDATE());
       
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`)
VALUES (@ItemsMaxId+1, 'currencyCode', 'CurrencyCode', @standardMasterMaxId+1, 'Varchar', '5', 0, 0, 0, 0, '1',SYSDATE());

END IF;   

END $$
CALL V20241003174119__Create_Stripe_ChildCSM () $$ 
DROP PROCEDURE IF EXISTS V20241003174119__Create_Stripe_ChildCSM $$ 
DELIMITER ;