DROP PROCEDURE IF EXISTS rpt_Admission_Summary;
DELIMITER $$
CREATE PROCEDURE `rpt_Admission_Summary`(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory varchar(5), ProgramGroup  varchar(5), seatType text)
BEGIN
   
declare StartDateNull boolean default if(StartDate is null,1,0);
declare EndDateNull boolean default if(EndDate is null,1,0);
declare ProgramCategoryNull boolean default if(ProgramCategory is null,1,0);
declare ProgramGroupNull boolean default if(ProgramGroup is null,1,0);
declare SeatTypeNull boolean default if(seatType is null or seatType='',1,0);

declare cur_Brand_Campus_ID,cur_alId,cur_programid,cur_programSequence, cur_seattypeid,cur_tot_admissions,cur_tot_weekly_admissions,cur_target_for_admission,cur_totalSuccessfulApplications,
cur_prev_tot_admissions int;
DECLARE cur_Brand_Campus,cur_grade VARCHAR(500);
declare  cur_Perc_Target_Admission,cur_conv_perc,cur_YOY_Variance_for_total_Admissions_target double default 0;

declare no_more_rows boolean default false;

  drop table if exists tbl_rpt_Admission_Summary_cursor;
   create table tbl_rpt_Admission_Summary_cursor(Brand_Campus text, Brand_Campus_ID long, programId long, grade varchar(500)
   , Total_Admission int default 0, Weekly_movement_Admission int default 0, 
   Target_for_admission int default 0 ,Perc_Target_Admission double default 0,totalSuccessfulApplications int default 0,conversion_perc_assessment double default 0, 
    prev_yr_tot_admission int default 0,YOY_Variance_for_total_Admissions_target double default 0,programSequence int default 0)
   comment 'Temporary Table for Admission Summary Report'; 
   
   call str_to_row (academyLocation);
   call str_to_row_seattype (seatType);

START TRANSACTION;
BLOCK1: begin
DECLARE cur CURSOR FOR

select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint,p.programSequence,absc.seattypeid
	from prog_batch_seat_config as absc
	join batches as b on absc.programBatchId=b.id
	join programs as p on b.programId=p.id and p.status='O' and p.programClosureDate is null
	join academy_location as al on p.academyLocationId = al.id
  	where  
	al.id in (select s from tbl_str_to_row) and b.intakeYearId = intakeYear
  	and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  	and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
    and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  	group by al.id, p.id; 
  
declare continue handler for not found  set no_more_rows := true;

OPEN cur;

 read_loop: LOOP
 
 FETCH cur INTO cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_programSequence, cur_seattypeid;
    
if no_more_rows then set no_more_rows := false;
        close cur;
        leave read_loop;
end if;  

	set cur_tot_admissions:=(select count(distinct a.id) as tot_admissions
  	from admission as a 
	join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId 
		where 
		(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
 		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
		and a.academyLocationId = cur_alId and p.id = cur_programid
  	group by a.academyLocationId, p.id);
    
    if no_more_rows then set cur_tot_admissions=0; set no_more_rows=false; end if;
    
set cur_tot_weekly_admissions:=(select count(distinct a.id) as tot_weekly_admissions
from admission as a 
join academy_location_purpose alp on a.academyLocationId = alp.academyLocationId
join calendars on alp.calendarId = calendars.id 
join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches as b on a.batchId = b.id and b.intakeYearId = intakeYear
join programs as p on p.id = b.programId
where date(a.admissionDate) between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0
	when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2
	when weekStart = 'THURSDAY' then 3 when weekStart = 'FRIDAY' then 4
	when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
and a.academyLocationId = cur_alId and p.id = cur_programid
group by a.academyLocationId, p.id) ;

 if no_more_rows then set cur_tot_weekly_admissions=0; set no_more_rows=false; end if;
 
set cur_target_for_admission:= (select (b.seatCapacity - count(distinct a.Id)) as target_for_admission
	   	from admission as a 
        join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where
		(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
		and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
		and a.status in ('ADMISSION_CONFIRMED', 'ADMITTED_PROVISIONALLY')
        and a.academyLocationId = cur_alId and p.id = cur_programid
	group by p.id, b.id limit 1) ;
    
 if no_more_rows then set cur_target_for_admission=0; set no_more_rows=false; end if;	   
 
 set cur_Perc_Target_Admission:= (select ifnull(cur_tot_admissions / NULLIF(cur_target_for_admission,0) * 100,0));
 if no_more_rows then set cur_Perc_Target_Admission=0; set no_more_rows=false; end if;	
 
 select apl.Total_SUCCESSFUL_Admission, (adm.tot_admissions / ifnull(apl.Total_SUCCESSFUL_Admission, 1) * 100) into cur_totalSuccessfulApplications, cur_conv_perc
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate, b.startDate, b.tillDate
	from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
		join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
		join programs p on p.id = b.programId
  	where 
			 (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
			and	(date(a.admissionDate)<= EndDate or 1 = EndDateNull)
  			and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  			and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
            and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  			 group by a.academyLocationId, p.id) as adm join
  	(Select al.id, p.id as grade_id, count(distinct a.id) as Total_SUCCESSFUL_Admission
  		from application a right join application_program ap on a.id=ap.applicationId
  		left join programs p on p.id = ap.programId
  		left join academy_location al on al.id = ap.academyLocationId 
		join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
		join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
  		where a.currentStatus in ('ADMISSION_GRANTED','APPROVED','DIRECT_ADMISSION','DIRECT_SUBMISSION_TOKEN_GENERATED','FORM_SALE_TOKEN_GENERATED','SOLD')
  		and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  		and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
		and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
 		and	(date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
       and al.id=cur_alId and  p.id=cur_programid
		group by al.id, p.id) apl
  	   on adm.academyLocationId = apl.id and adm.grade_id = apl.grade_id;
       -- this query is taking more time
    
     if no_more_rows then set cur_totalSuccessfulApplications=0; set cur_conv_perc=0; set no_more_rows=false; end if;	
    
 
   select  prev_yr_admission.tot_admissions ,
ifnull(((curr_yr_admission.tot_admissions - prev_yr_admission.tot_admissions)/NULLIF(prev_yr_admission.tot_admissions,0) * 100),
0) into cur_prev_tot_admissions,  cur_YOY_Variance_for_total_Admissions_target
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = (select id from intake_year
where itemValue = (select itemValue - 1 from intake_year where id = intakeYear limit 1) limit 1)
join programs p on p.id = b.programId
  where 
(p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
and (date(a.admissionDate)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
        and a.academyLocationId=cur_alID and cur_programId=p.id
  group by a.academyLocationId, p.id) as prev_yr_admission
   join (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, a.admissionDate
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join programs p on p.id = b.programId
  where 
       (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(a.admissionDate) >= StartDate or 1 = StartDateNull)
and (date(a.admissionDate)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
        and a.academyLocationId=cur_alID and p.id=cur_programId
  group by a.academyLocationId, p.id) as curr_yr_admission
   on prev_yr_admission.academyLocationId = curr_yr_admission.academyLocationId
   and prev_yr_admission.grade_id = curr_yr_admission.grade_id;
   
	if no_more_rows then set cur_prev_tot_admissions=0; set cur_YOY_Variance_for_total_Admissions_target=0; set no_more_rows=false; end if;	

   insert into tbl_rpt_Admission_Summary_cursor values(cur_Brand_Campus,cur_alId,cur_programid,cur_grade,cur_tot_admissions,cur_tot_weekly_admissions,cur_target_for_admission,
	cur_Perc_Target_Admission,cur_totalSuccessfulApplications,cur_conv_perc,cur_prev_tot_admissions,cur_YOY_Variance_for_total_Admissions_target,cur_programSequence);
       

END loop read_loop;

 select Brand_Campus_ID as academyLocationId, Brand_Campus as academyLocationName
  	, programId, grade as programName, (case when Total_Admission is null then 0 else Total_Admission end) as totalAdmission
  	,(case when Weekly_movement_Admission is null then 0 else Weekly_movement_Admission end) as WMofAdmission,(case when conversion_perc_assessment is null then 0 else conversion_perc_assessment end) as ConPercFromAs
  	,(case when Target_for_admission is null then 0 else Target_for_admission end) as targetForAdmission,(case when Perc_Target_Admission is null then 0 else Perc_Target_Admission end) as perOfTargetForAdmission
  	,(case when YOY_Variance_for_total_Admissions_target is null then 0 else YOY_Variance_for_total_Admissions_target end)  as yoyTotalAdmission,(case when prev_yr_tot_admission is null then 0 else prev_yr_tot_admission end) as prevTotalAdmission,(case when totalSuccessfulApplications is null then 0 else totalSuccessfulApplications end) totalSuccessfulApplications,(case when programSequence is null then 0 else programSequence end) as programSequence
   from tbl_rpt_Admission_Summary_cursor order by Brand_Campus,programSequence;

END BLOCK1;
commit;

END $$
DELIMITER ;
