DELIMITER $$
DROP PROCEDURE IF EXISTS V20241029150930__Alter_SOMMET_COURSE_DESCRIPTOR_PDF $$
CREATE PROCEDURE V20241029150930__Alter_SOMMET_COURSE_DESCRIPTOR_PDF()
BEGIN

SET @reportTempId = (select max(id) FROM report_type WHERE typeName ='Learning Plan');
	
IF not EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'SOMMET_COURSE_DESCRIPTOR_PDF')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTempId, 'SOMMET_COURSE_DESCRIPTOR_PDF', 'Sommet course descriptor pdf', 'SOMMET_COURSE_DESCRIPTOR_PDF.png', 'SOMMET_COURSE_DESCRIPTOR_PDF.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'SOMMET_COURSE_DESCRIPTOR_PDF.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='SOMMET_COURSE_DESCRIPTOR_PDF' and templateName='Sommet course descriptor pdf');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_VALIDATE_BY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_VALIDATE_BY', 'Validated By', '1', now());
END IF;

END $$
CALL V20241029150930__Alter_SOMMET_COURSE_DESCRIPTOR_PDF() $$
DROP PROCEDURE IF EXISTS V20241029150930__Alter_SOMMET_COURSE_DESCRIPTOR_PDF $$
DELIMITER ;