DELIMITER $$
DROP PROCEDURE IF EXISTS V20241129153950__Alter_ApplicantInsurancetable $$
CREATE PROCEDURE V20241129153950__Alter_ApplicantInsurancetable()
BEGIN
IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_insurance_detail') THEN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'validFrom')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `validFrom`  DATE NULL AFTER `schoolInsuranceType`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'validTo')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `validTo`  DATE NULL AFTER `validFrom`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'nameOfInsuranceCompany')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `nameOfInsuranceCompany` VARCHAR(255) DEFAULT NULL  AFTER `validTo`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'policyNumber')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `policyNumber` VARCHAR(255) DEFAULT NULL AFTER `nameOfInsuranceCompany`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'schoolInsuranceCardReceived')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `schoolInsuranceCardReceived` BIT(1) NOT NULL DEFAULT b'1' AFTER `policyNumber`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'receivedDate')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `receivedDate`  DATE NULL  AFTER `schoolInsuranceCardReceived`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'applicant_insurance_detail' AND COLUMN_NAME = 'remarks')) THEN 
ALTER TABLE applicant_insurance_detail
ADD COLUMN `remarks` VARCHAR(255) DEFAULT NULL AFTER `receivedDate`;
END IF;

END IF; 
END $$
CALL V20241129153950__Alter_ApplicantInsurancetable() $$
DROP PROCEDURE IF EXISTS V20241129153950__Alter_ApplicantInsurancetable $$
DELIMITER ;