DELIMITER $$
DROP PROCEDURE IF EXISTS V20241201190941__Create_PreExaminationDetail $$
CREATE PROCEDURE V20241201190941__Create_PreExaminationDetail()
BEGIN

IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = database() AND TABLE_NAME='pre_examination_detail') THEN 
CREATE TABLE `pre_examination_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `jobId` BIGINT NOT NULL,
  `courseId` BIGINT NOT NULL,
  `eventId` BIGINT NOT NULL,
  `duration` INTEGER DEFAULT NULL,
  `venueRemark` VARCHAR(256) DEFAULT NULL,
  `administeredBy` VARCHAR(256) DEFAULT NULL,
  `typeOfAssessment` VARCHAR(256) DEFAULT NULL,
  `isAnySpecialCharacter` VARCHAR(256) DEFAULT NULL,
  `accessoriesRequired` VARCHAR(256) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_pre_exam_to_eventId` (`eventId`),
  CONSTRAINT `FK_pre_exam_to_eventId` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`)
);

END IF; 

END $$
CALL V20241201190941__Create_PreExaminationDetail () $$ 
DROP PROCEDURE IF EXISTS V20241201190941__Create_PreExaminationDetail $$ 
DELIMITER ;